/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.vm;

import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterConfigExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterQueueConfiguration;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterStoreProfile;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingClusterQueueManager
implements org.mule.runtime.core.api.util.queue.QueueManager,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchingClusterQueueManager.class);
    private final ClusterQueueManager clusterQueueManager;
    private final ClusterStoreProfile defaultClusterStoreProfile;
    private org.mule.runtime.core.api.util.queue.QueueManager resolvedQueueManager;
    @Inject
    private MuleContext muleContext;
    @Inject
    @Named(value="_localQueueManager")
    private org.mule.runtime.core.api.util.queue.QueueManager localQueueManager;

    public SwitchingClusterQueueManager(ClusterQueueManager clusterQueueManager, ClusterStoreProfile defaultClusterStoreProfile) {
        this.clusterQueueManager = clusterQueueManager;
        this.defaultClusterStoreProfile = defaultClusterStoreProfile;
    }

    public void initialise() throws InitialisationException {
        ClusterQueueConfiguration queueConfiguration = this.defaultClusterStoreProfile.getQueueConfiguration();
        ClusterConfigExtension clusterConfiguration = (ClusterConfigExtension)((Object)this.muleContext.getConfiguration().getExtension(ClusterConfigExtension.class));
        if (clusterConfiguration != null) {
            queueConfiguration = clusterConfiguration.getClusterStoreProfile().getQueueConfiguration();
        }
        if (queueConfiguration.useDistributedQueues()) {
            QueueManagerWrapper wrapperManager = new QueueManagerWrapper();
            this.resolvedQueueManager = wrapperManager;
            wrapperManager.setQueueManager((QueueManager)this.clusterQueueManager);
            LifecycleUtils.initialiseIfNeeded((Object)this.clusterQueueManager, (boolean)true, (MuleContext)this.muleContext);
            this.clusterQueueManager.configureQueueBackups(queueConfiguration.getNumberOfBackups());
        } else {
            this.resolvedQueueManager = this.localQueueManager;
        }
    }

    public QueueSession getQueueSession() {
        return this.resolvedQueueManager.getQueueSession();
    }

    public void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.resolvedQueueManager.setDefaultQueueConfiguration(config);
    }

    public void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.resolvedQueueManager.setQueueConfiguration(queueName, config);
    }

    public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
        return this.resolvedQueueManager.getQueueConfiguration(queueName);
    }

    public void start() throws MuleException {
        this.resolvedQueueManager.start();
    }

    public void stop() throws MuleException {
        this.resolvedQueueManager.stop();
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.resolvedQueueManager, (Logger)LOGGER);
    }
}

