/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.persistence;

import com.hazelcast.map.MapLoader;
import com.hazelcast.map.MapStoreFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.config.persistence.JdbcDataSourceFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.config.persistence.JdbcMapStoreDataSourceConfiguration;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.JdbcMapStore;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.DatabaseStoreQueryBuilderStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.DefaultDatabaseStoreQueryBuilderStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.MicrosoftSqlDatabaseStoreQueryBuilderStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.MySqlDatabaseStoreQueryBuilderStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.PostgreSqlDatabaseStoreQueryBuilderStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.QueryBuilderStrategyEnum;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Properties;
import javax.sql.DataSource;
import org.mule.runtime.api.serialization.SerializationProtocol;

public class JdbcMapStoreFactory<T extends Serializable>
implements MapStoreFactory<Serializable, T> {
    private final SerializationProtocol serializationProtocol;
    private DataSource comboPooledDataSource;
    private String queryStrategy;
    private String tableNameTransformerStrategy;
    private JdbcMapStoreDataSourceConfiguration dataSourceConfiguration;

    public JdbcMapStoreFactory(String jdbcUrl, String driverClassName, String username, String password, String queryStrategy, SerializationProtocol serializationProtocol, String tableNameTransformerStrategy, Properties clusterProperties) {
        this.serializationProtocol = serializationProtocol;
        this.queryStrategy = queryStrategy;
        this.tableNameTransformerStrategy = tableNameTransformerStrategy;
        this.dataSourceConfiguration = this.getJdbcDataSourceConfiguration(jdbcUrl, username, password, driverClassName, clusterProperties);
    }

    public JdbcMapStoreFactory(String jdbcUrl, String driverClassName, String username, String password, String queryStrategy, SerializationProtocol serializationProtocol, String tableNameTransformerStrategy) {
        this(jdbcUrl, driverClassName, username, password, queryStrategy, serializationProtocol, tableNameTransformerStrategy, new Properties());
    }

    public static String getBadConnectionMessage(String driverClassName, String url) {
        return String.format("It was not possible to create a connection to the database for storing cluster data. The failing configuration attributes are: \nDriver class: %s \nurl: %s", driverClassName, url);
    }

    public MapLoader<Serializable, T> newMapStore(String mapName, Properties properties) {
        try {
            return new JdbcMapStore(this.getDataSourceInstance(), mapName, this.getDatabaseStoreQueryBuilderStrategy(this.queryStrategy, this.tableNameTransformerStrategy), this.serializationProtocol);
        }
        catch (Exception e) {
            throw new RuntimeException(JdbcMapStoreFactory.getBadConnectionMessage(this.dataSourceConfiguration.getDriverClassName(), this.dataSourceConfiguration.getJdbcUrl()), e);
        }
    }

    private DataSource getDataSource() throws PropertyVetoException {
        try {
            Class<?> clazz = Class.forName(this.dataSourceConfiguration.getFactoryClass());
            return ((JdbcDataSourceFactory)clazz.newInstance()).createDataSource(this.dataSourceConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating data source factory", e);
        }
    }

    private DataSource getDataSourceInstance() throws PropertyVetoException {
        if (this.comboPooledDataSource == null) {
            this.comboPooledDataSource = this.getDataSource();
        }
        return this.comboPooledDataSource;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DatabaseStoreQueryBuilderStrategy getDatabaseStoreQueryBuilderStrategy(String strategyName, String fileNameTransformerStrategy) {
        void var3_7;
        if (strategyName == null) throw new RuntimeException("Strategy for jdbc store queries can't be null");
        if (strategyName.equals(QueryBuilderStrategyEnum.MYSQL.getStrategyName())) {
            MySqlDatabaseStoreQueryBuilderStrategy mySqlDatabaseStoreQueryBuilderStrategy = new MySqlDatabaseStoreQueryBuilderStrategy(fileNameTransformerStrategy);
            return var3_7;
        } else if (strategyName.equals(QueryBuilderStrategyEnum.POSTGRESQL.getStrategyName())) {
            PostgreSqlDatabaseStoreQueryBuilderStrategy postgreSqlDatabaseStoreQueryBuilderStrategy = new PostgreSqlDatabaseStoreQueryBuilderStrategy(fileNameTransformerStrategy);
            return var3_7;
        } else if (strategyName.equals(QueryBuilderStrategyEnum.MSSQL.getStrategyName())) {
            MicrosoftSqlDatabaseStoreQueryBuilderStrategy microsoftSqlDatabaseStoreQueryBuilderStrategy = new MicrosoftSqlDatabaseStoreQueryBuilderStrategy(fileNameTransformerStrategy);
            return var3_7;
        } else {
            if (!strategyName.equals(QueryBuilderStrategyEnum.DEFAULT.getStrategyName())) throw new RuntimeException("Strategy for jdbc store queries not found");
            DefaultDatabaseStoreQueryBuilderStrategy defaultDatabaseStoreQueryBuilderStrategy = new DefaultDatabaseStoreQueryBuilderStrategy(fileNameTransformerStrategy);
        }
        return var3_7;
    }

    private JdbcMapStoreDataSourceConfiguration getJdbcDataSourceConfiguration(String jdbcStoreUrl, String jdbcStoreUsername, String jdbcStorePassword, String jdbcStoreDriver, Properties clusterProperties) {
        return JdbcMapStoreDataSourceConfiguration.Builder.newInstance().withJdbcUrl(jdbcStoreUrl).withUsername(jdbcStoreUsername).withPassword(jdbcStorePassword).withDriverClassName(jdbcStoreDriver).withClusterProperties(clusterProperties).build();
    }
}

