/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QueueConfig;

public class MuleDistributedObjectConfigurator {
    public static final String HAZELCAST_GW_MAPS_PREFIX = "gateway-policies-map-*";
    public static final String THROTTLING_ALGORITHM_EXECUTION_SERVICE_ID_TEMPLATE = "throttling-algorithm-execution-%s";

    public void configure(Config config, boolean readBackData, Integer backups) {
        this.configureDistributedMaps(config, readBackData, backups);
        this.configureGatewayPoliciesMaps(config);
        this.configureDistributedQueues(config, backups);
        this.configureDistributedThrottlingExecutorService(config);
    }

    private void configureDistributedThrottlingExecutorService(Config config) {
        config.getExecutorConfig(THROTTLING_ALGORITHM_EXECUTION_SERVICE_ID_TEMPLATE.replace("%s", "*")).setPoolSize(100);
    }

    private void configureDistributedMaps(Config config, boolean readBackData, Integer backups) {
        MapConfig defaultMapConfig = new MapConfig();
        defaultMapConfig.setName("*");
        defaultMapConfig.setReadBackupData(readBackData);
        defaultMapConfig.setBackupCount(backups.intValue());
        config.addMapConfig(defaultMapConfig);
    }

    private void configureDistributedQueues(Config config, Integer backups) {
        QueueConfig defaultQueueConfig = new QueueConfig();
        defaultQueueConfig.setName("*");
        defaultQueueConfig.setBackupCount(backups.intValue());
        config.addQueueConfig(defaultQueueConfig);
    }

    private void configureGatewayPoliciesMaps(Config config) {
        MapConfig gatewayPoliciesMapConfig = new MapConfig();
        gatewayPoliciesMapConfig.setName(String.format(HAZELCAST_GW_MAPS_PREFIX, "*"));
        config.addMapConfig(gatewayPoliciesMapConfig);
    }
}

