/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigLogger.class);

    public void log(Config config) {
        LOGGER.info("Mule cluster setup properties >>>");
        this.logClusterIds(config);
        this.logDiscoverySPIConfig(config);
        this.logReadBackupDataConfiguration(config);
        this.logClusterServersDiscoveryMode(config);
        this.logClusterPortUsage(config);
        this.logNetworkInterfaceUsage(config);
        this.logDataBackupCount(config);
        this.logManagementCenterConfiguration(config);
        this.logQuorumConfiguration(config);
        this.logJMXConfig(config);
        LOGGER.info("Mule cluster setup properties <<<");
    }

    private void logDiscoverySPIConfig(Config config) {
        String discoverySPIEnabled = config.getProperty(ClusterProperty.DISCOVERY_SPI_ENABLED.getName());
        if (Boolean.parseBoolean(discoverySPIEnabled)) {
            LOGGER.info("Discovery SPI is enabled");
            for (DiscoveryStrategyConfig dsConfig : config.getNetworkConfig().getJoin().getDiscoveryConfig().getDiscoveryStrategyConfigs()) {
                for (String key : dsConfig.getProperties().keySet()) {
                    LOGGER.info("Discovery SPI Property {}: {}", (Object)key, dsConfig.getProperties().get(key));
                }
            }
        } else {
            LOGGER.info("Discovery SPI is not enabled.");
        }
    }

    private void logClusterPortUsage(Config config) {
        LOGGER.info("Using port {} for inbound connections", (Object)config.getNetworkConfig().getPort());
        LOGGER.info("Inbound request port autoincrement is {}", (Object)(config.getNetworkConfig().isPortAutoIncrement() ? "enabled" : "disabled"));
        if (config.getNetworkConfig().getOutboundPorts() == null) {
            LOGGER.info("Using random port for outbound connections");
        } else {
            LOGGER.info("Using port/s {} for outbound connections", (Object)Arrays.toString(config.getNetworkConfig().getOutboundPorts().toArray()));
        }
    }

    private void logClusterIds(Config config) {
        LOGGER.info("Cluster id: {}", (Object)config.getClusterName());
        LOGGER.info("Cluster node id: {}", (Object)config.getInstanceName());
    }

    private void logManagementCenterConfiguration(Config config) {
        ManagementCenterConfig managementCenterConfig = config.getManagementCenterConfig();
        if (managementCenterConfig.isConsoleEnabled()) {
            LOGGER.info("Management center console connection enabled");
        }
    }

    private void logDataBackupCount(Config config) {
        LOGGER.info("Message backup count: {}", (Object)config.getMapConfig("default").getBackupCount());
    }

    private void logNetworkInterfaceUsage(Config config) {
        InterfacesConfig interfaces = config.getNetworkConfig().getInterfaces();
        if (interfaces.isEnabled()) {
            LOGGER.info("Network interfaces restriction enabled");
            LOGGER.info("Network interfaces to use: ");
            for (String eachInterface : interfaces.getInterfaces()) {
                LOGGER.info(" - {}", (Object)eachInterface);
            }
        } else {
            LOGGER.info("No network interface restriction. Using all available interfaces");
        }
    }

    private void logClusterServersDiscoveryMode(Config config) {
        if (config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            LOGGER.info("Multicast to discover cluster nodes enabled");
        } else {
            LOGGER.info("Multicast to discover cluster nodes disabled");
        }
        TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        if (tcpIpConfig.isEnabled()) {
            LOGGER.info("TCP/IP to discover cluster nodes enabled");
            LOGGER.info("TCP/IP time to connect {} seconds", (Object)tcpIpConfig.getConnectionTimeoutSeconds());
            List members = tcpIpConfig.getMembers();
            if (members.isEmpty()) {
                LOGGER.info("No cluster member ip was specified for TCP/IP discovery");
            } else {
                LOGGER.info("TCP/IP discovery members:");
                for (String member : members) {
                    LOGGER.info(" - {}", (Object)member);
                }
            }
        } else {
            LOGGER.info("TCP/IP to discover cluster nodes disabled");
        }
    }

    private void logReadBackupDataConfiguration(Config config) {
        LOGGER.info("Reading backup data: {}", (Object)config.getMapConfig("default").isReadBackupData());
    }

    private void logQuorumConfiguration(Config config) {
        SplitBrainProtectionConfig quorumConfig = config.getSplitBrainProtectionConfig("default-quorum");
        if (null != quorumConfig) {
            LOGGER.info("Quorum enabled: {}", (Object)quorumConfig.isEnabled());
            LOGGER.info("Quorum size: {}", (Object)quorumConfig.getMinimumClusterSize());
        }
    }

    private void logJMXConfig(Config config) {
        String value = config.getProperty("hazelcast.jmx");
        if (null != value) {
            LOGGER.info("JMX enabled: {}", (Object)value);
        }
    }
}

