/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.xa;

import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import com.mulesoft.mule.runtime.bti.internal.xa.AbstractMuleXAResourceProducer;
import com.mulesoft.mule.runtime.bti.internal.xa.MuleXAConnectionHandlerResourceHolder;
import com.mulesoft.mule.runtime.bti.internal.xa.connection.MuleXaPooledConnectionSupplier;
import javax.transaction.xa.XAResource;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleXAPooledConnectionHandlerResourceProducer
extends AbstractMuleXAResourceProducer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleXAPooledConnectionHandlerResourceProducer.class);
    private volatile transient XAPool pool;
    private transient Object[] constructorArgs = new Object[0];

    @Override
    public synchronized void init() {
        try {
            this.buildXAPool();
            super.init();
        }
        catch (Exception ex) {
            if (this.pool != null) {
                this.pool.close();
                this.pool = null;
            }
            if (ex instanceof ResourceConfigurationException) {
                ResourceConfigurationException rcEx = (ResourceConfigurationException)ex;
                throw rcEx;
            }
            throw new ResourceConfigurationException("cannot init MuleXAPooledConnectionHandlerResourceProducer for '" + this.getUniqueName() + "'", (Throwable)ex);
        }
    }

    @Override
    public synchronized void close() {
        if (this.pool == null) {
            return;
        }
        LOGGER.debug("closing {}", (Object)this.pool);
        this.pool.close();
        this.pool = null;
        super.close();
    }

    private void buildXAPool() throws Exception {
        if (this.pool != null) {
            return;
        }
        LOGGER.debug("building JMS XA pool for {} with {} connection(s)", (Object)this.getUniqueName(), (Object)this.getMinPoolSize());
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MuleXAPooledConnectionHandlerResourceProducer.class.getClassLoader());
            this.pool = new XAPool((XAResourceProducer)this, (ResourceBean)this, this.constructorArgs);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public void setConstructorArgs(Object ... constructorArgs) {
        this.constructorArgs = constructorArgs;
    }

    public void setFailed(boolean failed) {
        this.pool.setFailed(failed);
    }

    public boolean isFailed() {
        return this.pool.isFailed();
    }

    public ConnectionHandler<XATransactionalConnection> getConnectionHandler() throws ConnectionException {
        try {
            return (ConnectionHandler)this.pool.getConnectionHandle();
        }
        catch (Exception e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        LOGGER.debug("creating new XA connection...");
        MuleXaPooledConnectionSupplier connSupplier = (MuleXaPooledConnectionSupplier)xaFactory;
        ConnectionHandler conn = connSupplier.getConnection();
        XATransactionalConnection connection = (XATransactionalConnection)conn.getConnection();
        LOGGER.debug("created new XA connection: {}", (Object)connection);
        return new MuleXAConnectionHandlerResourceHolder(conn, connection, this);
    }

    public XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        return this.pool.findXAResourceHolder(xaResource);
    }

    @Override
    protected ConnectionHandler<XATransactionalConnection> getRecoveryConnectionHandler() throws ConnectionException {
        return this.getConnectionHandler();
    }
}

