/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.exception.ContractInconsistencyException;
import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientAuthenticator;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneApiContracts
implements ApiContracts {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneApiContracts.class);
    private final ApiKey key;
    private final List<ApiContractsListener> listeners;
    private Map<String, Contract> contracts;
    private boolean contractsLoaded = false;
    private final ClientAuthenticator clientAuthenticator;

    public StandaloneApiContracts(ApiKey key, List<ApiContractsListener> listeners) {
        this.key = key;
        this.listeners = listeners;
        this.contracts = new HashMap<String, Contract>();
        this.clientAuthenticator = new ClientAuthenticator();
    }

    public ApiContracts updateContracts(List<Contract> contracts) {
        this.checkNoNulls(contracts);
        this.contracts = contracts.stream().collect(Collectors.toMap(contract -> contract.client().id(), contract -> contract));
        this.contractsLoaded = true;
        this.listeners.forEach(listener -> listener.onContractsLoaded(this.key));
        return this;
    }

    public ApiContracts updateContracts(Contract ... contracts) {
        this.checkNoNulls(contracts);
        return this.updateContracts(Arrays.asList(contracts));
    }

    public Sla sla(Client client) throws ForbiddenClientException {
        if (!this.contracts.containsKey(client.id())) {
            throw this.noSlaDefinedInApi();
        }
        Contract contract = this.contracts.get(client.id());
        if (!this.clientAuthenticator.authenticate(contract.client(), client)) {
            throw this.noSlaDefinedInApi();
        }
        return contract.sla();
    }

    public Sla sla(String clientId) throws ForbiddenClientException {
        if (!this.contracts.containsKey(clientId)) {
            throw this.noSlaDefinedInApi();
        }
        return this.contracts.get(clientId).sla();
    }

    public Client validate(String clientId, String clientSecret) throws ForbiddenClientException {
        if (!this.contracts.containsKey(clientId)) {
            throw this.invalidClient();
        }
        Client client = this.contracts.get(clientId).client();
        if (!this.clientAuthenticator.authenticate(client, clientId, clientSecret)) {
            throw this.invalidClient();
        }
        return client;
    }

    public Client validate(String clientId) throws ForbiddenClientException {
        if (!this.contracts.containsKey(clientId)) {
            throw this.invalidClient();
        }
        return this.contracts.get(clientId).client();
    }

    public List<Contract> contracts() {
        return new ArrayList<Contract>(this.contracts.values());
    }

    public boolean contractsLoaded() {
        return this.contractsLoaded;
    }

    public void dispose() {
        this.contracts.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandaloneApiContracts apiContracts = (StandaloneApiContracts)o;
        if (!this.key.equals((Object)apiContracts.key)) {
            return false;
        }
        return this.contractsIn(apiContracts.contracts.values()) && apiContracts.contractsIn(this.contracts.values());
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.contracts.hashCode();
        return result;
    }

    public String toString() {
        return "ApiContracts{key=" + String.valueOf(this.key) + ", contracts=" + String.valueOf(this.contracts) + "}";
    }

    private ForbiddenClientException noSlaDefinedInApi() {
        return new ForbiddenClientException("No Sla defined for client in Api: " + String.valueOf(this.key));
    }

    private ForbiddenClientException invalidClient() {
        LOGGER.trace("Invalid client for Api:" + String.valueOf(this.key));
        return new ForbiddenClientException("Invalid Client");
    }

    private boolean contractsIn(Collection<Contract> thoseContracts) {
        return this.contracts.values().stream().allMatch(thisContract -> thoseContracts.stream().anyMatch(thatContract -> thatContract.equals(thisContract)));
    }

    private void checkNoNulls(List<Contract> contracts) {
        if (contracts == null || contracts.stream().anyMatch(Objects::isNull)) {
            throw new ContractInconsistencyException("Null contract found");
        }
    }

    private void checkNoNulls(Contract ... contracts) {
        if (contracts == null) {
            throw new ContractInconsistencyException("Null contract found");
        }
        this.checkNoNulls(Arrays.asList(contracts));
    }
}

