/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class OfflinePolicyDefinitionValidator {
    public static void validate(File definitionFile) {
        if (!definitionFile.exists()) {
            throw new OfflinePolicyDeserializationException("Policy definition file: " + String.valueOf(definitionFile) + " does not exist.");
        }
        if (!OfflinePolicyDefinitionValidator.hasJsonExtension(definitionFile)) {
            throw new OfflinePolicyDeserializationException("Invalid extension in " + String.valueOf(definitionFile));
        }
    }

    private static boolean hasJsonExtension(File definitionFile) {
        return FilenameUtils.getExtension((String)definitionFile.getName()).equals("json");
    }
}

