/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeperMuleContextListener;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class BlockingGateKeeper
extends GateKeeper {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(BlockingGateKeeper.class);
    private static final PolicyTemplateKey GATEKEEPER_POLICY_TEMPLATE_KEY = new PolicyTemplateKey("com.mulesoft.anypoint", "mule-gatekeeper-policy-template", MuleManifest.getProductVersion());
    private static final String GATEKEEPER_POLICY_ID = "gatekeeper";
    private final TransactionalPolicyDeploymentService policyDeployer;
    private final boolean blockFailedRevert;
    private final boolean blockEdit;

    public BlockingGateKeeper(ApiService apiService, TransactionalPolicyDeploymentService policyDeployer, boolean blockFailedRevert, boolean blockEdit) {
        super(apiService);
        this.policyDeployer = policyDeployer;
        this.blockFailedRevert = blockFailedRevert;
        this.blockEdit = blockEdit;
    }

    @Override
    public void onPoliciesRemoved(ApiKey apiKey) {
        this.getMonitoredApi(apiKey).ifPresent(api -> this.doBlockApi((Api)api));
    }

    @Override
    protected boolean isMonitored(Api api) {
        return !this.isHdp(api);
    }

    @Override
    public void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet, List<PolicyDefinitionDeploymentStatus> deploymentStatuses) {
        super.onPolicySetDeploymentCompleted(apiKey, policySet, deploymentStatuses);
    }

    @Override
    protected void blockApi(Api api) {
        MuleContext context = api.getImplementation().getFlow().getMuleContext();
        context.getNotificationManager().addListener((NotificationListener)new GateKeeperMuleContextListener(api, this));
    }

    protected void doBlockApi(Api api) {
        this.doBlockApi(api, false);
    }

    private void doBlockApi(Api api, boolean silent) {
        if (!this.isBlocked(api)) {
            ApiImplementation implementation = api.getImplementation();
            GatekeeperStatusTracker gatekeeperStatus = implementation.gatekeeperStatus();
            PolicyDefinition policyDefinition = this.gatekeeperPolicyDefinition(api);
            this.policyDeployer.deploy(policyDefinition, api);
            gatekeeperStatus.blocked(silent);
            LOGGER.info("API {} is blocked (unavailable).", (Object)implementation.getApiKey());
        }
    }

    @Override
    protected void unblockApi(Api api) {
        ApiImplementation implementation = api.getImplementation();
        this.policyDeployer.undeploy(this.gatekeeperPolicyDefinition(api), api);
        Level level = implementation.gatekeeperStatus().isSilent() ? Level.DEBUG : Level.INFO;
        implementation.gatekeeperStatus().unblocked();
        LOGGER.atLevel(level).log("API {} is now unblocked (available).", (Object)implementation.getApiKey());
    }

    @Override
    public void preUpdate(Api api, PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy) {
        if (this.blockEdit && this.isMonitored(api) && !this.isBlocked(api)) {
            LOGGER.debug("Applying Gatekeeper Policy to protect {} for edition of policy {} in application {}", new Object[]{api, oldPolicy.getName(), api.getImplementation().getArtifactName()});
            this.doBlockApi(api, true);
        }
    }

    @Override
    public void postUpdate(Api api, PolicyDeploymentStatus deploymentStatus) {
        if (this.blockFailedRevert && this.isMonitored(api) && !this.isBlocked(api) && this.isRevertFailed(deploymentStatus)) {
            this.doBlockApi(api, true);
        }
    }

    private boolean isRevertFailed(PolicyDeploymentStatus deploymentStatus) {
        return deploymentStatus.getLatestPolicyStatus().isRevertFailed();
    }

    private PolicyDefinition gatekeeperPolicyDefinition(Api api) {
        ApiImplementation implementation = api.getImplementation();
        return new OfflinePolicyDefinition(this.getPolicyId(api), GATEKEEPER_POLICY_TEMPLATE_KEY, implementation.getApiKey(), new ArrayList<HttpResourcePointcut>(), 1, new PolicyConfiguration(Collections.emptyMap()));
    }

    private String getPolicyId(Api api) {
        return "gatekeeper-" + api.getKey().id();
    }
}

