/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.framework.builder;

import com.mulesoft.mule.framework.api.builder.MuleVersionConfigurer;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.nio.file.Path;
import java.util.Objects;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;

public class DefaultMuleVersionConfigurer
implements MuleVersionConfigurer {
    private MuleVersion muleVersion;
    private DependencyResolver dependencyResolver;
    private boolean offline;
    private Path muleDistribution;

    @Override
    public MuleVersionConfigurer withMuleVersion(MuleVersion muleVersion) {
        Objects.requireNonNull(muleVersion, "'muleVersion' cannot be null");
        Preconditions.checkState((this.muleVersion == null ? 1 : 0) != 0, (String)"'muleVersion' is already set");
        this.muleVersion = muleVersion;
        return this;
    }

    @Override
    public MuleVersionConfigurer offline() {
        this.offline = true;
        return this;
    }

    @Override
    public MuleVersionConfigurer withDependencyResolver(DependencyResolver dependencyResolver) {
        Objects.requireNonNull(dependencyResolver, "'dependencyResolver' cannot be null");
        Preconditions.checkState((this.dependencyResolver == null ? 1 : 0) != 0, (String)"'dependencyResolver' is already set");
        Preconditions.checkState((this.muleDistribution == null ? 1 : 0) != 0, (String)"'muleDistribution' is already set, dependencies will be resolved from there");
        this.dependencyResolver = dependencyResolver;
        return this;
    }

    @Override
    public MuleVersionConfigurer fromMuleDistribution(Path muleDistribution) {
        Objects.requireNonNull(muleDistribution, "'muleDistribution' cannot be null");
        Preconditions.checkState((this.muleDistribution == null ? 1 : 0) != 0, (String)"'muleDistribution' is already set");
        Preconditions.checkState((this.dependencyResolver == null ? 1 : 0) != 0, (String)"'dependencyResolver' is already set, dependencies will be resolved with it");
        this.muleDistribution = muleDistribution;
        return this;
    }

    public MuleVersion getMuleVersion() {
        return this.muleVersion;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Path getMuleDistribution() {
        return this.muleDistribution;
    }

    public void validate() {
        Preconditions.checkState((this.muleVersion != null ? 1 : 0) != 0, (String)"'muleVersion' must be set");
    }
}

