/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;
import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.ws.DefaultWebSocketListener;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketByteFragmentListener;
import com.ning.http.client.ws.WebSocketCloseCodeReasonListener;
import com.ning.http.client.ws.WebSocketTextFragmentListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundWebSocketListener
extends DefaultWebSocketListener
implements WebSocketByteFragmentListener,
WebSocketTextFragmentListener,
WebSocketCloseCodeReasonListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundWebSocketListener.class);
    private final WebSocketCallback callback;
    private final String socketId;
    private volatile boolean connected = false;
    private OutboundWebSocket socket;

    public OutboundWebSocketListener(String socketId, WebSocketCallback callback) {
        this.socketId = socketId;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket webSocket) {
        super.onOpen(webSocket);
        OutboundWebSocketListener outboundWebSocketListener = this;
        synchronized (outboundWebSocketListener) {
            this.connected = true;
            if (this.socket != null) {
                this.callback.onConnect((org.mule.runtime.http.api.ws.WebSocket)this.socket);
            }
        }
    }

    public void onClose(WebSocket websocket, int code, String reason) {
        super.onClose(websocket);
        this.connected = false;
        this.callback.onClose((org.mule.runtime.http.api.ws.WebSocket)this.socket, WebSocketCloseCode.fromProtocolCode((int)code), reason);
    }

    public void onClose(WebSocket websocket) {
        this.onClose(this.webSocket, 1000, "");
    }

    public void onMessage(byte[] message) {
        this.callback.onMessage((org.mule.runtime.http.api.ws.WebSocket)this.socket, new TypedValue((Object)new ByteArrayInputStream(message), DataType.builder().type(InputStream.class).mediaType(MediaType.BINARY).build()));
    }

    public void onMessage(String message) {
        this.callback.onMessage((org.mule.runtime.http.api.ws.WebSocket)this.socket, new TypedValue((Object)new ByteArrayInputStream(message.getBytes()), DataType.TEXT_STRING));
    }

    public void onFragment(HttpResponseBodyPart fragment) {
        FragmentHandler handler = this.socket.getFragmentHandler(h -> this.callback.onMessage((org.mule.runtime.http.api.ws.WebSocket)this.socket, new TypedValue((Object)h.getInputStream(), DataType.builder().type(InputStream.class).mediaType(MediaType.BINARY).build())));
        try {
            if (!handler.write(fragment.getBodyPartBytes()) && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Incoming fragment for socket '{}' was discarded because the stream was already closed");
            }
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("Error found while streaming data on socket '%s': %s. Stream will be closed", this.socket.getId(), e.getMessage()), (Throwable)e);
                handler.abort();
            }
            return;
        }
        if (fragment.isLast()) {
            handler.complete();
        }
    }

    public void onError(Throwable t) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(String.format("The following error was catched for %sSocket '%s': %s", this.socket != null ? this.socket.getType().name() + " " : "", this.socketId, t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSocket(OutboundWebSocket socket) {
        OutboundWebSocketListener outboundWebSocketListener = this;
        synchronized (outboundWebSocketListener) {
            this.socket = socket;
            if (this.connected) {
                this.callback.onConnect((org.mule.runtime.http.api.ws.WebSocket)socket);
            }
        }
    }
}

