/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.queue;

import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.exception.BatchException;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.LoadingQueueBuffer;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.RecordBuffer;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.routing.split.MessageSequence;
import org.mule.runtime.core.internal.routing.split.SplittingStrategy;
import org.mule.runtime.tracer.api.EventTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchQueueLoader {
    private static final Logger logger = LoggerFactory.getLogger(BatchQueueLoader.class);
    private final SplittingStrategy<CoreEvent, MessageSequence<?>> splittingStrategy;
    private final BatchEngine batchEngine;
    private final int blockSize;
    private final NotificationDispatcher notificationDispatcher;
    private final EventTracer<CoreEvent> coreEventTracer;

    public BatchQueueLoader(BatchEngine batchEngine, int blockSize, SplittingStrategy<CoreEvent, MessageSequence<?>> splittingStrategy, NotificationDispatcher notificationDispatcher, EventTracer<CoreEvent> coreEventTracer) {
        this.batchEngine = batchEngine;
        this.blockSize = blockSize;
        this.splittingStrategy = splittingStrategy;
        this.notificationDispatcher = notificationDispatcher;
        this.coreEventTracer = coreEventTracer;
    }

    public long splitAndLoad(BatchJob job, BatchJobInstanceAdapter jobInstance, CoreEvent event) throws MuleException {
        RecordBuffer buffer = this.newQueueBuffer();
        MessageSequence messageSequence = (MessageSequence)this.splittingStrategy.split((Object)event);
        long recordCount = 0L;
        String stepId = job.getSteps().get(0).getName();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Starting loading phase for instance '%s' of job '%s'", jobInstance.getId(), jobInstance.getOwnerJobName()));
        }
        BatchTransactionContext ctx = this.batchEngine.createTransactionContext(jobInstance);
        jobInstance.getBatchEvent().setSerializedBatchJobInstanceSpan(this.coreEventTracer.getDistributedTraceContextMap((Event)event));
        try {
            while (messageSequence.hasNext()) {
                Record record = BatchUtils.toRecord(event, messageSequence.next());
                record.setCurrentStepId(stepId);
                buffer.add(jobInstance, ctx, record);
                ++recordCount;
            }
            buffer.flush(jobInstance);
        }
        catch (Exception e) {
            throw new BatchException(I18nMessageFactory.createStaticMessage((String)String.format("Exception found while trying to load queue for instance %s of job %s", jobInstance.getId(), jobInstance.getOwnerJobName())), e, jobInstance);
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Finished loading phase for instance %s of job %s. %d records were loaded", jobInstance.getId(), jobInstance.getOwnerJobName(), recordCount));
        }
        return recordCount;
    }

    private RecordBuffer newQueueBuffer() {
        try {
            return new LoadingQueueBuffer(this.batchEngine.getBatchQueueManager(), this.blockSize, this.notificationDispatcher);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

