/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.proxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.service.http.netty.impl.client.proxy.BlindTunnelingProxyClientHandler;
import org.mule.service.http.netty.impl.client.proxy.MessageForwardingProxyClientHandler;

public class ProxyPipelineConfigurer {
    private final ProxyConfig proxyConfig;

    public ProxyPipelineConfigurer(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void configurePipeline(ChannelPipeline pipeline, SocketAddress remoteAddress, boolean useTunneling) {
        if (this.proxyConfig == null) {
            return;
        }
        if (this.isNonProxyHost(this.proxyConfig.getNonProxyHosts(), remoteAddress)) {
            return;
        }
        if (useTunneling) {
            pipeline.addFirst("TunnelProxyHandler", (ChannelHandler)new BlindTunnelingProxyClientHandler(this.proxyConfig));
            return;
        }
        pipeline.addAfter("reactor.left.httpCodec", "ProxyAuthHandler", (ChannelHandler)new MessageForwardingProxyClientHandler(this.proxyConfig));
    }

    private boolean isNonProxyHost(String nonProxyHosts, SocketAddress socketAddress) {
        if (nonProxyHosts == null || nonProxyHosts.isEmpty()) {
            return false;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return false;
        }
        String hostString = ((InetSocketAddress)socketAddress).getHostString();
        for (String nonProxyHost : nonProxyHosts.split(",")) {
            if (!nonProxyHost.trim().equals(hostString)) continue;
            return true;
        }
        return false;
    }
}

