/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployableClassLoaderConfigurationAssembler;
import org.mule.runtime.module.artifact.activation.internal.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.artifact.activation.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployableArtifactDescriptorFactory<M extends MuleDeployableModel, T extends DeployableArtifactDescriptor>
extends AbstractArtifactDescriptorFactory<M, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployableArtifactDescriptorFactory.class);
    private final DeployableProjectModel deployableProjectModel;
    private final Optional<Properties> deploymentProperties;
    private final PluginModelResolver pluginModelResolver;
    private final PluginDescriptorResolver pluginDescriptorResolver;
    private final BundlePluginDependenciesResolver pluginDependenciesResolver;

    public AbstractDeployableArtifactDescriptorFactory(DeployableProjectModel deployableProjectModel, Map<String, String> deploymentProperties, PluginModelResolver pluginModelResolver, PluginDescriptorResolver pluginDescriptorResolver, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(deployableProjectModel.getProjectFolder(), artifactDescriptorValidatorBuilder);
        this.deployableProjectModel = deployableProjectModel;
        this.deploymentProperties = this.asProperties(deploymentProperties);
        this.pluginModelResolver = pluginModelResolver;
        this.pluginDescriptorResolver = pluginDescriptorResolver;
        this.pluginDependenciesResolver = new BundlePluginDependenciesResolver();
    }

    private Optional<Properties> asProperties(Map<String, String> deploymentProperties) {
        Properties properties = new Properties();
        properties.putAll(deploymentProperties);
        return properties.isEmpty() ? Optional.empty() : Optional.of(properties);
    }

    protected Optional<Properties> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    @Override
    protected ClassLoaderConfiguration getClassLoaderConfiguration(MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        return new DeployableClassLoaderConfigurationAssembler(this.deployableProjectModel, muleArtifactLoaderDescriptor).createClassLoaderConfiguration();
    }

    @Override
    protected BundleDescriptor getBundleDescriptor() {
        return this.deployableProjectModel.getDescriptor();
    }

    protected M getDeployableModel() {
        return (M)this.deployableProjectModel.getDeployableModel();
    }

    protected BundlePluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    @Override
    protected void doDescriptorConfig(T descriptor) {
        Set configs;
        descriptor.setArtifactLocation(this.getArtifactLocation());
        descriptor.setRedeploymentEnabled(((MuleDeployableModel)this.getArtifactModel()).isRedeploymentEnabled());
        if (this.getArtifactLocation().isDirectory()) {
            descriptor.setRootFolder(this.getArtifactLocation());
        }
        if ((configs = ((MuleDeployableModel)this.getArtifactModel()).getConfigs()) != null && !configs.isEmpty()) {
            descriptor.setConfigResources(new HashSet(configs));
        } else {
            descriptor.setConfigResources((Set)ImmutableSet.builder().add((Object)this.getDefaultConfigurationResource()).build());
        }
        descriptor.setPlugins(this.createArtifactPluginDescriptors((DeployableArtifactDescriptor)descriptor));
        descriptor.setLogConfigFile(this.getLogConfigFile((MuleDeployableModel)this.getArtifactModel()));
        descriptor.setSupportedJavaVersions(((MuleDeployableModel)this.getArtifactModel()).getSupportedJavaVersions());
    }

    private File getLogConfigFile(M artifactModel) {
        File logConfigFile = null;
        if (artifactModel.getLogConfigFile() != null) {
            Path logConfigFilePath = new File(artifactModel.getLogConfigFile()).toPath();
            Path muleHomeFolderPath = MuleFoldersUtil.getMuleHomeFolder().toPath();
            logConfigFile = muleHomeFolderPath.resolve(logConfigFilePath).toFile();
        }
        return logConfigFile;
    }

    private Set<ArtifactPluginDescriptor> createArtifactPluginDescriptors(DeployableArtifactDescriptor descriptor) {
        HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
        for (BundleDependency bundlePluginDependency : descriptor.getClassLoaderConfiguration().getDependencies()) {
            BundleDescriptor bundleDescriptor = bundlePluginDependency.getDescriptor();
            if (!bundleDescriptor.isPlugin()) continue;
            if (bundlePluginDependency.getBundleUri() == null) {
                LOGGER.warn(String.format("Plugin '%s' is declared as 'provided' which means that it will not be added to the artifact's classpath", bundleDescriptor));
                continue;
            }
            List bundleDependencies = bundlePluginDependency.getTransitiveDependenciesList();
            pluginDescriptors.add(this.pluginDescriptorResolver.resolve(Collections.emptySet(), bundleDescriptor).orElse(this.createPluginDescriptor(bundlePluginDependency, this.pluginModelResolver.resolve(bundlePluginDependency), descriptor, bundleDependencies, this.deployableProjectModel.getSharedLibraries())));
        }
        return pluginDescriptors;
    }

    protected abstract String getDefaultConfigurationResource();

    private ArtifactPluginDescriptor createPluginDescriptor(BundleDependency bundleDependency, MulePluginModel pluginModel, DeployableArtifactDescriptor ownerDescriptor, List<BundleDependency> pluginBundleDependencies, Set<BundleDescriptor> sharedPluginDependencies) {
        return (ArtifactPluginDescriptor)new ArtifactPluginDescriptorFactory(bundleDependency, pluginModel, ownerDescriptor, pluginBundleDependencies, sharedPluginDependencies, ArtifactDescriptorValidatorBuilder.builder()).create();
    }
}

