/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class PolicyTemplateAssets {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(PolicyTemplateAssets.class);
    private final String templateName;
    private final File templateJarFile;
    private final File templateYamlFile;
    private final File templateExtractedJarFolder;

    public PolicyTemplateAssets(String templateName, File templateJarFile, File templateExtractedJarFolder) {
        this(templateName, templateJarFile, null, templateExtractedJarFolder);
    }

    public PolicyTemplateAssets(String templateName, File templateJarFile, File templateYamlFile, File templateExtractedJarFolder) {
        this.templateName = templateName;
        this.templateJarFile = templateJarFile;
        this.templateYamlFile = templateYamlFile;
        this.templateExtractedJarFolder = templateExtractedJarFolder;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public File getTemplateJarFile() {
        return this.templateJarFile;
    }

    public File getTemplateYamlFile() {
        return this.templateYamlFile;
    }

    public File getTemplateExtractedJarFolder() {
        return this.templateExtractedJarFolder;
    }

    public void delete() {
        try {
            this.templateJarFile.delete();
            if (this.templateYamlFile != null) {
                this.templateYamlFile.delete();
            }
            FileUtils.deleteDirectory((File)this.templateExtractedJarFolder);
            LOGGER.debug("Policy template {} was deleted successfully", (Object)this.templateName);
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected error trying to delete folder {}", (Object)this.templateExtractedJarFolder, (Object)e);
        }
    }
}

