/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.generator;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.generator.BaseRequestHandlerGenerator;
import com.mulesoft.modules.oauth2.provider.internal.processor.AuthorizationRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.ServeLoginPageProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.ValidateAuthorizationRequestProcessor;
import java.util.Arrays;
import java.util.Set;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;

public class AuthorizationHandlerGenerator
extends BaseRequestHandlerGenerator {
    @Override
    public void generate(OAuthConfiguration configuration) {
        HttpServer httpServer = configuration.getHttpServer();
        OAuth2ProviderRequestProcessor oAuth2ProviderRequestProcessor = new OAuth2ProviderRequestProcessor(configuration);
        ValidateAuthorizationRequestProcessor validateAuthorizationRequestProcessor = new ValidateAuthorizationRequestProcessor(configuration);
        ServeLoginPageProcessor serveLoginPageProcessor = new ServeLoginPageProcessor(configuration);
        AuthorizationRequestProcessor authorizationRequestProcessor = new AuthorizationRequestProcessor(configuration);
        this.requestHandlerManager = httpServer.addRequestHandler(Arrays.asList(HttpConstants.Method.GET.toString(), HttpConstants.Method.POST.toString()), configuration.getAuthorizationConfig().getPath(), (requestContext, responseCallback) -> {
            HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
            OAuth2ProviderProcessor oAuth2ProviderProcessor = requestContext.getRequest().getMethod().equalsIgnoreCase(HttpConstants.Method.GET.toString()) ? (httpRequestContext, responseBuilder) -> {
                Pair<Set<String>, Client> responsePair = validateAuthorizationRequestProcessor.process(httpRequestContext);
                serveLoginPageProcessor.process(httpRequestContext, (Client)responsePair.getSecond(), (Set)responsePair.getFirst(), responseBuilder);
            } : authorizationRequestProcessor::processRequest;
            oAuth2ProviderRequestProcessor.process(requestContext, httpResponseBuilder, oAuth2ProviderProcessor);
            responseCallback.responseReady(httpResponseBuilder.build(), Utils.getResponseStatusCallback());
        });
    }
}

