/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml;

import com.mulesoft.modules.cryptography.api.xml.config.XmlEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.xml.config.XmlEncryptionAlgorithmResolver;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import org.apache.xml.security.algorithms.JCEMapper;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public final class EphemeralKeyGenerator {
    private EphemeralKeyGenerator() {
    }

    public static Key createSymmetricKey(XmlEncryptionAlgorithm algorithm) {
        try {
            return EphemeralKeyGenerator.createKeyGenerator(algorithm).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Unable to generate symmetric key - " + e.getMessage())), (ErrorTypeDefinition)CryptoErrors.KEY);
        }
    }

    private static KeyGenerator createKeyGenerator(XmlEncryptionAlgorithm encryptionSymAlgorithm) throws NoSuchAlgorithmException {
        String algorithm = XmlEncryptionAlgorithmResolver.getAlgorithmUri(encryptionSymAlgorithm, XmlEncryptionAlgorithmResolver.getDefaultKeySize(encryptionSymAlgorithm));
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
        if (keyAlgorithm == null || keyAlgorithm.isEmpty()) {
            keyAlgorithm = JCEMapper.translateURItoJCEID((String)algorithm);
        }
        KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
        keyGen.init(XmlEncryptionAlgorithmResolver.getDefaultKeySize(encryptionSymAlgorithm) * 8);
        return keyGen;
    }
}

