/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp.config;

import com.mulesoft.modules.cryptography.internal.pgp.PgpKeystore;
import java.math.BigInteger;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@ExclusiveOptionals(isOneRequired=true)
public class PgpAsymmetricKeyIdentifier {
    @Parameter
    @Optional
    private String fingerprint;
    @Parameter
    @Optional
    private String principal;

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Long getFingerprint(PgpKeystore keystore) {
        if (this.fingerprint != null) {
            return new BigInteger(this.fingerprint, 16).longValue();
        }
        return keystore.getFingerprintFromPrincipal(this.principal);
    }

    public String toString() {
        if (this.fingerprint != null) {
            return String.format("key with fingerprint '%s'", this.fingerprint);
        }
        return String.format("key with principal '%s'", this.principal);
    }
}

