/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpSignatureAlgorithm;
import com.mulesoft.modules.cryptography.internal.CryptoUtils;
import com.mulesoft.modules.cryptography.internal.WrappedErrorPipedInputStream;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.BouncyCastleClasses;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpSigner {
    private PgpConfiguration config;
    private static final String PGP_SIGNATURE_ERROR_MESSAGE = "Could not sign with PGP";
    private static final String PGP_VALIDATION_INCORRECT_FORMAT_ERROR_MESSAGE = "The signed content does not have the correct format.";
    private static final int BUFFER_SIZE = 65536;

    public PgpSigner(PgpConfiguration config) {
        this.config = config;
    }

    public InputStream sign(InputStream inputStream, PgpKeyInfo keyInfo, PgpSignatureAlgorithm algorithm, Scheduler scheduler, Boolean armoredTransform) {
        try {
            if (keyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signing is only possible with asymmetric keys"), (ErrorTypeDefinition)CryptoErrors.KEY);
            }
            Class<?> bCPGOutputStream = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.BCPGOutputStream");
            Class<?> armoredOutputStream = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.ArmoredOutputStream");
            WrappedErrorPipedInputStream input = new WrappedErrorPipedInputStream();
            PipedOutputStream outputStream = new PipedOutputStream(input);
            OutputStream bcpgOutputStream = (OutputStream)bCPGOutputStream.getDeclaredConstructor(OutputStream.class).newInstance(outputStream);
            OutputStream armoredOutputStreamInstance = (OutputStream)armoredOutputStream.getDeclaredConstructor(OutputStream.class).newInstance(bcpgOutputStream);
            scheduler.submit(() -> this.asyncSign(inputStream, keyInfo, algorithm, armoredTransform, armoredOutputStreamInstance, bcpgOutputStream, input));
            return input;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)PGP_SIGNATURE_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream asyncSign(InputStream inputStream, PgpKeyInfo keyInfo, PgpSignatureAlgorithm algorithm, Boolean armoredTransform, OutputStream armoredOutputStream, Object bcpgOutputStream, WrappedErrorPipedInputStream input) {
        try {
            int len;
            Class<?> pGPPrivateKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPrivateKey");
            Class<?> publicKeyPacket = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.PublicKeyPacket");
            Class<?> jcaPGPContentSignerBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder");
            Class<?> pGPSignatureGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureGenerator");
            Class<?> pGPContentSignerBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPContentSignerBuilder");
            Class<?> pGPSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignature");
            Object pgpPrivateKey = keyInfo.getPrivateKey(this.config.getKeystore());
            Object keyPacket = pGPPrivateKey.getDeclaredMethod("getPublicKeyPacket", new Class[0]).invoke(pgpPrivateKey, new Object[0]);
            int keyAlgorithm = (Integer)publicKeyPacket.getDeclaredMethod("getAlgorithm", new Class[0]).invoke(keyPacket, new Object[0]);
            Object contentSignerBuilder = jcaPGPContentSignerBuilder.getDeclaredConstructor(Integer.TYPE, Integer.TYPE).newInstance(keyAlgorithm, algorithm.getNumericId());
            CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
                try {
                    jcaPGPContentSignerBuilder.getDeclaredMethod("setProvider", Provider.class).invoke(contentSignerBuilder, provider);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            Object signatureGenerator = pGPSignatureGenerator.getDeclaredConstructor(pGPContentSignerBuilder).newInstance(contentSignerBuilder);
            int binaryDocument = (Integer)pGPSignature.getField("BINARY_DOCUMENT").get(null);
            pGPSignatureGenerator.getDeclaredMethod("init", Integer.TYPE, pGPPrivateKey).invoke(signatureGenerator, binaryDocument, pgpPrivateKey);
            byte[] buf = new byte[65536];
            while ((len = inputStream.read(buf)) >= 0) {
                pGPSignatureGenerator.getDeclaredMethod("update", byte[].class, Integer.TYPE, Integer.TYPE).invoke(signatureGenerator, buf, 0, len);
            }
            Object pgpSignatureInstance = pGPSignatureGenerator.getDeclaredMethod("generate", new Class[0]).invoke(signatureGenerator, new Object[0]);
            pGPSignature.getDeclaredMethod("encode", OutputStream.class).invoke(pgpSignatureInstance, Boolean.TRUE.equals(armoredTransform) ? armoredOutputStream : bcpgOutputStream);
        }
        catch (ModuleException e) {
            input.fail(e);
        }
        catch (Exception e) {
            input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)PGP_SIGNATURE_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)armoredOutputStream);
            IOUtils.closeQuietly((Closeable)((Closeable)bcpgOutputStream));
        }
        return input;
    }

    public boolean validate(InputStream inputStream, InputStream expectedSignature) {
        try {
            Object pgpSigList;
            Class<?> pGPObjectFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPObjectFactory");
            Class<?> jcapGPObjectFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory");
            Class<?> pGPCompressedData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPCompressedData");
            Class<?> keyFingerPrintCalculator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator");
            Class<?> pGPSignatureList = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureList");
            Class<?> pGPSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignature");
            Class<?> pGPUtil = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPUtil");
            InputStream sigInputStream = (InputStream)pGPUtil.getDeclaredMethod("getDecoderStream", InputStream.class).invoke(null, expectedSignature);
            Object pgpObjFactory = jcapGPObjectFactory.getDeclaredConstructor(InputStream.class).newInstance(sigInputStream);
            Object obj = pGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpObjFactory, new Object[0]);
            if (Objects.isNull(obj)) {
                throw new ModuleException(PGP_VALIDATION_INCORRECT_FORMAT_ERROR_MESSAGE, (ErrorTypeDefinition)CryptoErrors.VALIDATION);
            }
            if (obj.getClass().equals(pGPCompressedData)) {
                InputStream dataStream = (InputStream)pGPCompressedData.getDeclaredMethod("getDataStream", new Class[0]).invoke(obj, new Object[0]);
                pgpObjFactory = pGPObjectFactory.getDeclaredConstructor(InputStream.class, keyFingerPrintCalculator).newInstance(dataStream, null);
                pgpSigList = pGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpObjFactory, new Object[0]);
            } else {
                pgpSigList = obj;
            }
            Object sig = pGPSignatureList.getDeclaredMethod("get", Integer.TYPE).invoke(pgpSigList, 0);
            long keyId = (Long)pGPSignature.getDeclaredMethod("getKeyID", new Class[0]).invoke(sig, new Object[0]);
            Object pubKey = this.config.getKeystore().getPublicKey(keyId);
            try {
                this.loadSignatureToValidate(sig, pubKey, inputStream);
            }
            catch (ModuleException e) {
                throw e;
            }
            catch (Exception e) {
                String message = CryptoUtils.getSafeErrorMessage(e, "PGP signature verification failed");
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)message), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
            }
            sigInputStream.close();
            return (Boolean)pGPSignature.getDeclaredMethod("verify", new Class[0]).invoke(sig, new Object[0]);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            String message = CryptoUtils.getSafeErrorMessage(e, "PGP signature verification failed");
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)message), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }

    private Object loadSignatureToValidate(Object sig, Object pubKey, InputStream inputStream) throws IOException {
        try {
            int len;
            Class<?> jcaPGPContentVerifierBuilderProvider = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider");
            Class<?> pGPSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignature");
            Class<?> pGPPublicKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKey");
            Class<?> pGPContentVerifierBuilderProvider = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider");
            Object verifierBuilderProvider = jcaPGPContentVerifierBuilderProvider.newInstance();
            CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
                try {
                    jcaPGPContentVerifierBuilderProvider.getDeclaredMethod("setProvider", Provider.class).invoke(verifierBuilderProvider, provider);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            pGPSignature.getDeclaredMethod("init", pGPContentVerifierBuilderProvider, pGPPublicKey).invoke(sig, verifierBuilderProvider, pubKey);
            byte[] buf = new byte[65536];
            while ((len = inputStream.read(buf)) >= 0) {
                pGPSignature.getDeclaredMethod("update", byte[].class, Integer.TYPE, Integer.TYPE).invoke(sig, buf, 0, len);
            }
            return sig;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

