/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.impl;

import com.mulesoft.modules.cryptography.internal.CryptoUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.encrypter.JCEPbeEncryptor;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceKeyImpl;
import com.mulesoft.modules.cryptography.internal.jce.parser.PbeAlgorithmParser;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcePbeImpl
extends JceKeyImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcePbeImpl.class);
    private static final Integer DEFAULT_KEY_LENGTH = 256;
    private final String password;
    private final String passwordSalt;
    private final int iterationCount;
    private final PbeAlgorithmParser.ParsedAlgorithm parsed;

    public JcePbeImpl(String password, String passwordSalt, int iterationCount, String algorithm) {
        if (password == null) {
            throw new ModuleException("The password cannot be empty for PBE operations", (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
        this.password = password;
        this.passwordSalt = passwordSalt;
        this.iterationCount = iterationCount;
        this.parsed = PbeAlgorithmParser.parse(algorithm);
    }

    @Override
    public String sign(InputStream content, String algorithm) {
        this.validateForEncryptionIfNeeded(algorithm);
        return this.doSign(content);
    }

    @Override
    public boolean validate(InputStream value, String expected, String algorithm) {
        this.validateForDecryptionIfNeeded(algorithm);
        String actual = this.doSign(value);
        return actual.equals(expected);
    }

    public PbeAlgorithmParser.ParsedAlgorithm getParsed() {
        return this.parsed;
    }

    @Override
    protected void validateForDecryptionIfNeeded(String algorithm) {
        boolean allowSunProvider = CryptoUtils.allowLegacyDecryptionSunProvider();
        boolean hasParams = this.passwordSalt != null && this.iterationCount > 0;
        boolean allowDefaults = CryptoUtils.allowLegacyDecryptionKdf();
        if (this.parsed.isSunStyleTransformation()) {
            boolean isFips = CryptoUtils.isFipsEnabled();
            if (isFips && !allowSunProvider) {
                throw new ModuleException(String.format("Algorithm '%s' is not FIPS-compliant. Use PBKDF2-based algorithms or enable legacy support via -D%s=true.", algorithm, "com.mulesoft.crypto.allow-sun-pbe-in-fips"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
            }
            if (!hasParams && !allowDefaults) {
                throw new ModuleException(String.format("Salt and iteration count must be set, or enable legacy mode with -D%s=true.", "com.mulesoft.crypto.allow-default-kdf-params"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
            }
            if (isFips && hasParams) {
                throw new ModuleException("The legacy support is only to decrypt old data with default parameters.", (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
            }
        } else if (!hasParams) {
            throw new ModuleException("Salt and iteration count must be set explicitly for this algorithm.", (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
    }

    @Override
    protected void validateForEncryptionIfNeeded(String algorithm) {
        if (this.parsed.isSunStyleTransformation() && CryptoUtils.isFipsEnabled()) {
            throw new ModuleException("Algorithm '" + algorithm + "' is not allowed in FIPS mode. Use PBKDF2-based algorithms.", (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
        if (this.passwordSalt == null || this.passwordSalt.trim().isEmpty() || this.iterationCount <= 0) {
            throw new ModuleException("Salt and iteration count must be set explicitly for encryption or signing.", (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
    }

    @Override
    protected Encrypter encrypter(String algorithm, Optional<Provider> provider) {
        boolean useJcePbeEncryptor;
        PBEKeySpec keySpec = this.buildKeySpec();
        boolean allowSunLegacy = CryptoUtils.allowLegacyDecryptionSunProvider();
        boolean bl = useJcePbeEncryptor = this.parsed.isSunStyleTransformation() && (!CryptoUtils.isFipsEnabled() || allowSunLegacy);
        if (useJcePbeEncryptor) {
            return new JCEPbeEncryptor(this.parsed.transformationString, (EncryptionKeyFactory)((SymmetricKeyFactory)() -> this.getKeyFromPBEKeySpec(keySpec, this.parsed.transformationString, PbeContext.ENCRYPT)), keySpec);
        }
        SymmetricKeyFactory symmetricKeyFactory = () -> new SecretKeySpec(this.getKeyFromPBEKeySpec(keySpec, this.parsed.kdfAlgorithm, PbeContext.ENCRYPT).getEncoded(), this.parsed.cipherAlgorithm);
        return new JCEEncrypter(this.parsed.transformationString, (EncryptionKeyFactory)symmetricKeyFactory);
    }

    private String doSign(InputStream content) {
        try {
            Mac mac = this.createMac();
            byte[] contentBytes = IOUtils.toByteArray((InputStream)content);
            mac.update(contentBytes);
            byte[] result = mac.doFinal();
            return new String(Base64.getEncoder().encode(result));
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not sign data"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    private Mac createMac() {
        try {
            Mac mac;
            if (this.parsed.isSunStyleTransformation()) {
                try {
                    mac = Mac.getInstance(this.parsed.kdfAlgorithm, "SunJCE");
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    mac = Mac.getInstance(this.parsed.kdfAlgorithm);
                }
                PBEParameterSpec pbeParameterSpec = this.buildPbeParameterSpec();
                try {
                    Key key = this.getKeyFromPBEKeySpec(this.buildKeySpec(), this.parsed.kdfAlgorithm, PbeContext.SIGN);
                    mac.init(key, pbeParameterSpec);
                }
                catch (Exception e) {
                    try {
                        SecretKey key = SecretKeyFactory.getInstance("PBE").generateSecret(new PBEKeySpec(this.password.toCharArray()));
                        mac.init(key, pbeParameterSpec);
                    }
                    catch (InvalidKeySpecException ex) {
                        throw new MuleRuntimeException((Throwable)ex);
                    }
                }
            } else {
                String[] parts = this.parsed.kdfAlgorithm.split("with");
                if (parts.length == 2) {
                    String macAlgorithm = parts[1];
                    try {
                        mac = Mac.getInstance(macAlgorithm, "BCFIPS");
                    }
                    catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                        mac = Mac.getInstance(macAlgorithm);
                    }
                    Key key = this.getKeyFromPBEKeySpec(this.buildKeySpec(), this.parsed.kdfAlgorithm, PbeContext.SIGN);
                    mac.init(key);
                } else {
                    throw new IllegalArgumentException("Invalid KDF algorithm format: " + this.parsed.kdfAlgorithm);
                }
            }
            return mac;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not initialize Mac"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Unsupported algorithm: " + this.parsed.kdfAlgorithm)), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    private PBEParameterSpec buildPbeParameterSpec() {
        if (this.passwordSalt != null && this.iterationCount > 0) {
            return new PBEParameterSpec(this.passwordSalt.getBytes(StandardCharsets.UTF_8), this.iterationCount);
        }
        if (!CryptoUtils.allowLegacyDecryptionKdf()) {
            throw new ModuleException(String.format("Salt and iteration count must be set explicitly. If you're decrypting legacy data, enable legacy mode via -D%s=true", "com.mulesoft.crypto.allow-default-kdf-params"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
        LOGGER.warn("You are using a default salt and iteration count for the PBE operation. This is not recommended for production environments.");
        return new PBEParameterSpec("12345678".getBytes(), JCEPbeEncryptor.DEFAULT_ITERATOR_COUNT_VALUE);
    }

    private PBEKeySpec buildKeySpec() {
        int keyLength = this.parsed.getKeyLength();
        if (keyLength == 0 && this.parsed.kdfAlgorithm != null && this.parsed.kdfAlgorithm.startsWith("PBKDF2withHmac")) {
            keyLength = DEFAULT_KEY_LENGTH;
        }
        if (this.passwordSalt != null && this.iterationCount > 0) {
            if (keyLength > 0) {
                return new PBEKeySpec(this.password.toCharArray(), this.passwordSalt.getBytes(StandardCharsets.UTF_8), this.iterationCount, keyLength);
            }
            return new PBEKeySpec(this.password.toCharArray(), this.passwordSalt.getBytes(StandardCharsets.UTF_8), this.iterationCount);
        }
        return new PBEKeySpec(this.password.toCharArray());
    }

    private Key getKeyFromPBEKeySpec(PBEKeySpec keySpec, String name, PbeContext context) {
        if (context == PbeContext.ENCRYPT) {
            return this.getKeyForEncryption(keySpec, name);
        }
        if (context == PbeContext.SIGN) {
            return this.getKeyForSigning(keySpec);
        }
        throw new IllegalArgumentException("Unsupported PBE context: " + (Object)((Object)context));
    }

    private Key getKeyForEncryption(PBEKeySpec keySpec, String name) {
        try {
            SecretKeyFactory keyFactory = this.parsed.isSunStyleTransformation() ? SecretKeyFactory.getInstance("PBE") : SecretKeyFactory.getInstance(name);
            return keyFactory.generateSecret(keySpec);
        }
        catch (AssertionError | Exception e) {
            String errorMessage = CryptoUtils.getSafeErrorMessage((Throwable)e, e instanceof AssertionError && e.getClass().getName().contains("FipsUnapprovedOperation") ? "Operation not approved in FIPS mode" : "Could not generate key for algorithm " + name);
            throw new ModuleException(errorMessage, (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    private Key getKeyForSigning(PBEKeySpec keySpec) {
        try {
            SecretKeyFactory kdfFactory = this.parsed.isSunStyleTransformation() ? SecretKeyFactory.getInstance("PBE") : SecretKeyFactory.getInstance(this.parsed.kdfAlgorithm);
            byte[] derived = kdfFactory.generateSecret(keySpec).getEncoded();
            return new SecretKeySpec(derived, this.parsed.kdfAlgorithm);
        }
        catch (AssertionError | Exception e) {
            String errorMessage = CryptoUtils.getSafeErrorMessage((Throwable)e, e instanceof AssertionError && e.getClass().getName().contains("FipsUnapprovedOperation") ? "Operation not approved in FIPS mode" : "Could not generate key for algorithm " + this.parsed.kdfAlgorithm);
            throw new ModuleException(errorMessage, (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    public static enum PbeContext {
        ENCRYPT,
        SIGN;

    }
}

