/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.config;

import com.mulesoft.modules.cryptography.api.jce.config.JceAsymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.jce.config.JceKeyInfo;
import com.mulesoft.modules.cryptography.api.jce.config.JceKeystoreType;
import com.mulesoft.modules.cryptography.internal.CryptoUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.JceKeystore;
import com.mulesoft.modules.cryptography.internal.jce.JceOperations;
import com.mulesoft.modules.cryptography.internal.xml.XmlOperations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration(name="jce")
@Operations(value={JceOperations.class, XmlOperations.class})
public class JceConfiguration
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JceConfiguration.class);
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE, location=PathModel.Location.EMBEDDED)
    @Summary(value="In FIPS environments, keystore format must be BCFKS.")
    String keystore;
    @Parameter
    @Summary(value="In FIPS environments, keystore format must be BCFKS.")
    JceKeystoreType type;
    @Parameter
    @Optional
    String password;
    @Parameter
    @NullSafe
    @Optional
    List<JceKeyInfo> jceKeyInfos;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Use random IVs")
    @Summary(value="Use random initial vectors (IVs) for CBC algorithms. In case of decryption, it assumes IV is prepended on the ciphertext.")
    boolean useRandomIVs;
    private JceKeystore jceKeystore;
    private Map<String, JceKeyInfo> keyInfoMap;

    public void initialise() throws InitialisationException {
        this.keyInfoMap = new HashMap<String, JceKeyInfo>();
        try {
            if (this.keystore != null) {
                this.jceKeystore = new JceKeystore(this.keystore, this.type, this.password);
            }
            this.jceKeyInfos.forEach(keyInfo -> {
                JceAsymmetricKeyInfo asymmetricKeyInfo;
                if (keyInfo instanceof JceAsymmetricKeyInfo && !this.jceKeystore.keyExists((asymmetricKeyInfo = (JceAsymmetricKeyInfo)keyInfo).getAlias())) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Key with alias '%s' was not found", (Object[])new Object[]{asymmetricKeyInfo.getAlias()}));
                }
                this.keyInfoMap.put(keyInfo.getKeyId(), (JceKeyInfo)keyInfo);
            });
            if (this.type.equals((Object)JceKeystoreType.JKS) && CryptoUtils.isFipsEnabled()) {
                LOGGER.warn("JKS is not compliant with FIPS rules and should be avoided when working in a secure environment.");
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public JceKeystore getKeystore() {
        return this.jceKeystore;
    }

    public boolean getUseRandomIVs() {
        return this.useRandomIVs;
    }

    public JceKeyInfo getKeyInfoFromId(String keyId) {
        JceKeyInfo keyInfo = this.keyInfoMap.get(keyId);
        if (keyInfo == null) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)String.format("Key with keyId '%s' was not found", keyId)), (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return keyInfo;
    }
}

