/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.checksum;

import com.mulesoft.modules.cryptography.api.checksum.ChecksumAlgorithm;
import com.mulesoft.modules.cryptography.internal.CryptoUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumAlgorithmImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecksumAlgorithmImpl.class);
    private static final String DEPRECATED_WARNING = "{} is not recommended for use, consider using a more secure algorithm. It is provided for legacy purposes only and it is deprecated.";
    private static final String CHECKSUM_ERROR_MESSAGE = "Error calculating checksum";
    private static final String FIPS_ERROR_MESSAGE = "The algorithm %s is not allowed in FIPS mode";
    private static final String INPUT_STREAM_NULL_ERROR_MESSAGE = "Input stream cannot be null";
    private final Map<ChecksumAlgorithm, IOFunction<InputStream, String>> digestFunctions = new EnumMap<ChecksumAlgorithm, IOFunction<InputStream, String>>(ChecksumAlgorithm.class);

    public ChecksumAlgorithmImpl() {
        this.initializeDigestFunctions();
    }

    private void initializeDigestFunctions() {
        this.digestFunctions.put(ChecksumAlgorithm.CRC32, this::calculateCRC32);
        this.digestFunctions.put(ChecksumAlgorithm.MD2, DigestUtils::md2Hex);
        this.digestFunctions.put(ChecksumAlgorithm.MD5, DigestUtils::md5Hex);
        this.digestFunctions.put(ChecksumAlgorithm.SHA_1, DigestUtils::sha1Hex);
        this.digestFunctions.put(ChecksumAlgorithm.SHA_256, DigestUtils::sha256Hex);
        this.digestFunctions.put(ChecksumAlgorithm.SHA_512, DigestUtils::sha512Hex);
    }

    public String digest(ChecksumAlgorithm algorithm, InputStream inputStream) {
        if (inputStream == null) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)INPUT_STREAM_NULL_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.CHECKSUM);
        }
        if (algorithm.isWeak() && CryptoUtils.isFipsEnabled()) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)String.format(FIPS_ERROR_MESSAGE, new Object[]{algorithm})), (ErrorTypeDefinition)CryptoErrors.CHECKSUM);
        }
        if (algorithm.isWeak()) {
            LOGGER.warn(DEPRECATED_WARNING, (Object)algorithm);
        }
        try {
            return this.digestFunctions.get((Object)algorithm).apply(inputStream);
        }
        catch (IOException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)CHECKSUM_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.CHECKSUM, (Throwable)e);
        }
    }

    private String calculateCRC32(InputStream inputStream) throws IOException {
        CRC32 sum = new CRC32();
        try (InputStream in = inputStream;){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                sum.update(buffer, 0, bytesRead);
            }
        }
        return Long.toHexString(sum.getValue());
    }

    public Map<ChecksumAlgorithm, IOFunction<InputStream, String>> getDigestFunctions() {
        return this.digestFunctions;
    }

    @FunctionalInterface
    private static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

