/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal;

import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoUtils.class);
    public static final String LEGACY_KDF_PROPERTY = "com.mulesoft.crypto.allow-default-kdf-params";
    public static final String LEGACY_SUN_PROVIDER_PROPERTY = "com.mulesoft.crypto.allow-sun-pbe-in-fips";
    public static final String ALLOW_REGISTRATION_XMLDSIG_PROPERTY = "com.mulesoft.connectors.allow-registration-of-xmldsig-provider-in-fips";
    public static final String ALLOW_CUSTOM_CIPHER_PROPERTY = "com.mulesoft.crypto.allow-custom-cipher-in-pbkdf2-format";
    public static final String ALLOW_NON_STANDARD_KEY_SIZE_PROPERTY = "com.mulesoft.crypto.allow.non.standard.key.size";
    public static final String XMLDSIG_PROVIDER_NAME = "XMLDSig";
    public static final String XMLDSIG_PROVIDER_CLASS = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static Provider instance = null;

    private CryptoUtils() {
    }

    public static boolean isFipsEnabled() {
        return "fips140-2".equals(System.getProperty("mule.security.model"));
    }

    public static void addMissingProvidersIfApplicable() {
        boolean providerRegistered;
        boolean bl = providerRegistered = Security.getProvider(XMLDSIG_PROVIDER_NAME) != null;
        if (providerRegistered) {
            return;
        }
        if (CryptoUtils.isFipsEnabled()) {
            if (Boolean.getBoolean(ALLOW_REGISTRATION_XMLDSIG_PROPERTY)) {
                try {
                    Security.addProvider((Provider)Class.forName(XMLDSIG_PROVIDER_CLASS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    LOGGER.info("The XMLDSigRI provider was registered as requested via system property. It is now available to all applications on the JVM.");
                }
                catch (Exception e) {
                    LOGGER.error("Unable to register XMLDSigRI provider.", (Throwable)e);
                }
            } else {
                LOGGER.warn("The XMLDSigRI provider is not available in the current environment. To enable XML signature support, activate it via -D{}=true. See the cryptography module reference for more information.", (Object)ALLOW_REGISTRATION_XMLDSIG_PROPERTY);
            }
        } else {
            try {
                Security.addProvider((Provider)Class.forName(XMLDSIG_PROVIDER_CLASS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                LOGGER.warn("The XMLDSigRI provider was registered. It is now available to all applications on the JVM.");
            }
            catch (Exception e) {
                LOGGER.error("Unable to register XMLDSigRI provider.", (Throwable)e);
            }
        }
    }

    public static Optional<Provider> getBcSecurityProviderIfApplicable() {
        try {
            if (CryptoUtils.isFipsEnabled()) {
                return Optional.empty();
            }
            if (Security.getProvider("BC") != null || Security.getProvider("BCFIPS") != null) {
                return Optional.empty();
            }
            if (instance != null) {
                return Optional.of(instance);
            }
            instance = CryptoUtils.tryLoadProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
            if (instance != null) {
                return Optional.of(instance);
            }
            instance = CryptoUtils.tryLoadProvider("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            return Optional.ofNullable(instance);
        }
        catch (Exception e) {
            String message = CryptoUtils.getSafeErrorMessage(e, "Error initializing Bouncy Castle Security Provider");
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)e);
        }
    }

    private static Provider tryLoadProvider(String providerClassName) {
        Provider o = null;
        try {
            o = (Provider)Class.forName(providerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return o;
        }
        catch (ClassNotFoundException e) {
            return o;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error initializing provider: " + providerClassName, e);
        }
    }

    public static boolean allowLegacyDecryptionKdf() {
        return Boolean.getBoolean(LEGACY_KDF_PROPERTY);
    }

    public static boolean allowLegacyDecryptionSunProvider() {
        return Boolean.getBoolean(LEGACY_SUN_PROVIDER_PROPERTY);
    }

    public static String getSafeErrorMessage(Throwable e, String defaultMessage) {
        String causeMessage;
        if (e == null) {
            return defaultMessage;
        }
        if (e.getCause() != null && (causeMessage = e.getCause().getMessage()) != null && !causeMessage.trim().isEmpty()) {
            return causeMessage;
        }
        String message = e.getMessage();
        if (message != null && !message.trim().isEmpty()) {
            return message;
        }
        return defaultMessage;
    }
}

