/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.bouncycastle.shaded.bcpg.BCPGInputStream;
import org.bouncycastle.shaded.bcpg.BCPGKey;
import org.bouncycastle.shaded.bcpg.BCPGObject;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.bcpg.ContainedPacket;
import org.bouncycastle.shaded.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.shaded.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.shaded.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.shaded.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.shaded.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.shaded.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.shaded.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.shaded.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.shaded.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.shaded.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.shaded.bcpg.X448PublicBCPGKey;

public class PublicKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_6 = 6;
    private int version;
    private long time;
    private int validDays;
    private int algorithm;
    private BCPGKey key;

    PublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        this.time = (long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
        if (this.version <= 3) {
            this.validDays = bCPGInputStream.read() << 8 | bCPGInputStream.read();
        }
        this.algorithm = (byte)bCPGInputStream.read();
        if (this.version == 6) {
            long l = (long)bCPGInputStream.read() << 24 | (long)bCPGInputStream.read() << 16 | (long)bCPGInputStream.read() << 8 | (long)bCPGInputStream.read();
        }
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: {
                this.key = new RSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 17: {
                this.key = new DSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 16: 
            case 20: {
                this.key = new ElGamalPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 18: {
                this.key = new ECDHPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 19: {
                this.key = new ECDSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 22: {
                this.key = new EdDSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 25: {
                this.key = new X25519PublicBCPGKey(bCPGInputStream);
                break;
            }
            case 26: {
                this.key = new X448PublicBCPGKey(bCPGInputStream);
                break;
            }
            case 27: {
                this.key = new Ed25519PublicBCPGKey(bCPGInputStream);
                break;
            }
            case 28: {
                this.key = new Ed448PublicBCPGKey(bCPGInputStream);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered: " + this.algorithm);
            }
        }
    }

    public PublicKeyPacket(int n, Date date, BCPGKey bCPGKey) {
        this.version = 4;
        this.time = date.getTime() / 1000L;
        this.algorithm = n;
        this.key = bCPGKey;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public Date getTime() {
        return new Date(this.time * 1000L);
    }

    public BCPGKey getKey() {
        return this.key;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream.write(this.version);
        bCPGOutputStream.write((byte)(this.time >> 24));
        bCPGOutputStream.write((byte)(this.time >> 16));
        bCPGOutputStream.write((byte)(this.time >> 8));
        bCPGOutputStream.write((byte)this.time);
        if (this.version <= 3) {
            bCPGOutputStream.write((byte)(this.validDays >> 8));
            bCPGOutputStream.write((byte)this.validDays);
        }
        bCPGOutputStream.write(this.algorithm);
        if (this.version == 6) {
            int n = this.key.getEncoded().length;
            bCPGOutputStream.write(n >> 24);
            bCPGOutputStream.write(n >> 16);
            bCPGOutputStream.write(n >> 8);
            bCPGOutputStream.write(n);
        }
        bCPGOutputStream.writeObject((BCPGObject)((Object)this.key));
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(6, this.getEncodedContents());
    }
}

