/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp.config;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpAsymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.PgpKeystore;
import com.mulesoft.modules.cryptography.internal.pgp.PgpOperations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

@Configuration(name="pgp")
@Operations(value={PgpOperations.class})
public class PgpConfiguration
implements Initialisable {
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE, location=PathModel.Location.EMBEDDED)
    String publicKeyring;
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE, location=PathModel.Location.EMBEDDED)
    String privateKeyring;
    @Parameter
    @NullSafe
    @Optional
    List<PgpKeyInfo> pgpKeyInfos;
    private PgpKeystore pgpKeystore;
    private Map<String, PgpKeyInfo> keyInfoMap;

    public void initialise() throws InitialisationException {
        this.keyInfoMap = new HashMap<String, PgpKeyInfo>();
        try {
            this.pgpKeystore = new PgpKeystore(this.publicKeyring, this.privateKeyring);
            this.pgpKeyInfos.forEach(keyInfo -> {
                this.keyInfoMap.put(keyInfo.getKeyId(), (PgpKeyInfo)keyInfo);
                if (keyInfo instanceof PgpAsymmetricKeyInfo) {
                    PgpAsymmetricKeyInfo asymmetricKeyInfo = (PgpAsymmetricKeyInfo)keyInfo;
                    Long fingerprint = this.pgpKeystore.getFingerprintFromIdentifier(asymmetricKeyInfo.getKeyIdentifier());
                    if (fingerprint == null) {
                        throw new RuntimeException(asymmetricKeyInfo.getKeyIdentifier().toString() + " was not found");
                    }
                    if (asymmetricKeyInfo.getPassphrase() != null) {
                        this.pgpKeystore.registerPassphrase(fingerprint, asymmetricKeyInfo.getPassphrase());
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public PgpKeyInfo getKeyInfoFromId(String keyId) {
        PgpKeyInfo keyInfo = this.keyInfoMap.get(keyId);
        if (keyInfo == null) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)String.format("Key with keyId '%s' was not found", keyId)), (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return keyInfo;
    }

    public PgpKeystore getKeystore() {
        return this.pgpKeystore;
    }
}

