/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.internal.WrappedErrorPipedInputStream;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import org.bouncycastle.shaded.bcpg.ArmoredOutputStream;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpTransformer {
    private static final int BUFFER_SIZE = 65536;

    public static InputStream binaryToArmored(InputStream content, Scheduler scheduler) {
        try {
            WrappedErrorPipedInputStream input = new WrappedErrorPipedInputStream();
            PipedOutputStream outputStream = new PipedOutputStream(input);
            ArmoredOutputStream out = new ArmoredOutputStream(outputStream);
            try {
                scheduler.submit(() -> {
                    try {
                        int len;
                        byte[] buf = new byte[65536];
                        while ((len = content.read(buf)) >= 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    catch (Exception e) {
                        input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not transform binary to armored"), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e));
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)out);
                        IOUtils.closeQuietly((Closeable)outputStream);
                    }
                });
                return input;
            }
            catch (Exception e) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not transform binary to armored"), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not transform binary to armored"), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e);
        }
    }
}

