/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.operation;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.awslambda.api.metadata.FunctionVersionEnum;
import com.mulesoft.connectors.awslambda.internal.config.AwsLambdaConfiguration;
import com.mulesoft.connectors.awslambda.internal.config.CustomConfigurationOverrides;
import com.mulesoft.connectors.awslambda.internal.metadata.Get20150331FunctionsOutputMetadataResolver;
import com.mulesoft.connectors.awslambda.internal.operation.CustomBaseRestOperation;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class Get20150331FunctionsOperation
extends CustomBaseRestOperation {
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="List Functions")
    @Summary(value="Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.")
    @MediaType(value="application/json")
    @OutputResolver(output=Get20150331FunctionsOutputMetadataResolver.class)
    public void get20150331Functions(@Config AwsLambdaConfiguration config, @Connection RestConnection connection, @Optional @DisplayName(value="Master Region") @Summary(value="For Lambda@Edge functions, the AWS Region of the master function.") String masterRegion, @Optional @DisplayName(value="Function Version") @Summary(value="Set to ALL to include entries for all published versions of each function.") FunctionVersionEnum functionVersion, @Optional @DisplayName(value="Marker") @Summary(value="Specify the pagination token that's returned by a previous request to retrieve the next page of results.") String marker, @Optional @DisplayName(value="Max Items") @Summary(value="The maximum number of functions to return in the response.") Integer maxItems, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") CustomConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/2015-03-31/functions";
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("MasterRegion", masterRegion).addQueryParam("FunctionVersion", functionVersion != null ? functionVersion.getValue() : null).addQueryParam("Marker", marker).addQueryParam("MaxItems", maxItems != null ? String.valueOf(maxItems) : null);
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

