/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.operation;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.awslambda.api.metadata.XAmzInvocationTypeEnum;
import com.mulesoft.connectors.awslambda.api.metadata.XAmzLogTypeEnum;
import com.mulesoft.connectors.awslambda.internal.config.AwsLambdaConfiguration;
import com.mulesoft.connectors.awslambda.internal.config.CustomConfigurationOverrides;
import com.mulesoft.connectors.awslambda.internal.metadata.Create20150331FunctionsInvocationsByFunctionNameInputMetadataResolver;
import com.mulesoft.connectors.awslambda.internal.metadata.Create20150331FunctionsInvocationsByFunctionNameOutputMetadataResolver;
import com.mulesoft.connectors.awslambda.internal.operation.CustomBaseRestOperation;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class Create20150331FunctionsInvocationsByFunctionNameOperation
extends CustomBaseRestOperation {
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("\\{FunctionName}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Invoke")
    @Summary(value="Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously.")
    @MediaType(value="application/json")
    @OutputResolver(output=Create20150331FunctionsInvocationsByFunctionNameOutputMetadataResolver.class)
    public void create20150331FunctionsInvocationsByFunctionName(@Config AwsLambdaConfiguration config, @Connection RestConnection connection, @DisplayName(value="Function Name") @Summary(value="The name of the Lambda function, version, or alias.") String functionName, @Optional @DisplayName(value="Qualifier") @Summary(value="Specify a version or alias to invoke a published version of the function.") String qualifier, @Optional @DisplayName(value="X Amz Invocation Type") @Summary(value="Choose from the following options.    RequestResponse (default) - Invoke the function synchronously.") XAmzInvocationTypeEnum xAmzInvocationType, @Optional @DisplayName(value="X Amz Log Type") @Summary(value="Set to Tail to include the execution log in the response.") XAmzLogTypeEnum xAmzLogType, @Optional @DisplayName(value="X Amz Client Context") @Summary(value="Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.") String xAmzClientContext, @Content(primary=true) @DisplayName(value="Body") @TypeResolver(value=Create20150331FunctionsInvocationsByFunctionNameInputMetadataResolver.class) TypedValue<InputStream> j_20150331FunctionsInvocationsContent, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") CustomConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/2015-03-31/functions/{FunctionName}/invocations";
        requestPath = FUNCTION_NAME_PATTERN.matcher(requestPath).replaceAll(functionName);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.POST, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/json").addHeader("accept", "application/json").addQueryParam("Qualifier", qualifier).addHeader("X-Amz-Invocation-Type", xAmzInvocationType != null ? xAmzInvocationType.getValue() : null).addHeader("X-Amz-Log-Type", xAmzLogType != null ? xAmzLogType.getValue() : null).addHeader("X-Amz-Client-Context", xAmzClientContext).setBody(j_20150331FunctionsInvocationsContent, StreamingType.NEVER);
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

