/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.amazon;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.BaseConnectionProvider;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.OptionalTlsParameterGroup;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.TlsParameterGroup;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.validation.ConnectionValidationSettings;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsCredentials;
import com.mulesoft.connectors.awslambda.internal.amazon.RegionValuesProvider;
import com.mulesoft.connectors.awslambda.internal.amazon.client.AwsHttpClient;
import com.mulesoft.connectors.awslambda.internal.amazon.client.AwsStsHttpClient;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

@Alias(value="connection")
@DisplayName(value="Amazon Lambda Connection")
public class AwsConnectionProvider
extends BaseConnectionProvider {
    private static final String SERVICE_NAME = "lambda";
    @Parameter
    @DisplayName(value="Access Key")
    @Placement(order=1)
    @Summary(value="The access key provided by Amazon.")
    private String accessKey;
    @Parameter
    @DisplayName(value="Secret Key")
    @Placement(order=2)
    @Summary(value="The secret key provided by Amazon.")
    private String secretKey;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="Role ARN")
    @Placement(order=3)
    @Summary(value="The ARN of the role to use.")
    private String roleArn;
    @Parameter
    @DisplayName(value="Region")
    @Placement(order=3)
    @Summary(value="The region of the amazon instance.")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="us-east-1")
    @OfValues(value=RegionValuesProvider.class)
    private String region;
    @ParameterGroup(name="tls")
    private OptionalTlsParameterGroup tlsConfig;
    @Parameter
    @DisplayName(value="Custom Service Endpoint")
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced", order=11)
    @Summary(value="Sets a custom service endpoint. Useful when a non-standard service endpoint is required, such as a VPC endpoint.")
    private String customServiceEndpoint;
    @Parameter
    @DisplayName(value="Custom STS Endpoint")
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced", order=12)
    @Summary(value="Sets a custom STS endpoint. Useful when a non-standard STS endpoint is required.")
    private String customStsEndpoint;

    @Override
    public String getBaseUri() {
        String serviceEndpoint = this.getCustomServiceEndpoint();
        return serviceEndpoint != null && !serviceEndpoint.isEmpty() ? serviceEndpoint : String.format("https://%s.%s.amazonaws.com", SERVICE_NAME, this.getRegion());
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCustomServiceEndpoint() {
        return this.customServiceEndpoint;
    }

    public String getCustomStsEndpoint() {
        return this.customStsEndpoint;
    }

    @Override
    public Optional<TlsParameterGroup> getTlsConfig() {
        return Optional.ofNullable(this.tlsConfig);
    }

    private HttpClient wrapHttpClient(HttpClient client) {
        if (this.getRoleArn() != null && !this.getRoleArn().isEmpty()) {
            return new AwsStsHttpClient(client, SERVICE_NAME, new AwsCredentials(this.getAccessKey(), this.getSecretKey(), this.getRegion()), this.getRoleArn(), this.getCustomStsEndpoint());
        }
        return new AwsHttpClient(client, SERVICE_NAME, new AwsCredentials(this.getAccessKey(), this.getSecretKey(), this.getRegion()));
    }

    @Override
    protected RestConnection createConnection(HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders) {
        return new DefaultRestConnection(this.getBaseUri(), this.getConfigName(), this.wrapHttpClient(httpClient), authentication, defaultQueryParams, defaultHeaders, this.getExpressionLanguage());
    }

    @Override
    public ConnectionValidationResult validate(RestConnection restConnection) {
        ConnectionValidationSettings settings = ConnectionValidationSettings.builder("/2015-03-31/functions", this.getExpressionLanguage()).build();
        return super.validate(restConnection, settings);
    }
}

