/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions.DataExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class SequenceCompositeDataExpression
implements DataExpression {
    private final List<Step> steps = new ArrayList<Step>();

    public SequenceCompositeDataExpression(List<Step> steps) {
        this.steps.addAll(steps);
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        Object result = null;
        for (Step step : this.steps) {
            result = step.getDataExpression().evaluate(evaluationContext);
            this.defineResultForNextEvaluationContext(evaluationContext, result);
            this.defineStepForNextEvaluationContext(evaluationContext, step, result);
        }
        return result;
    }

    private void defineStepForNextEvaluationContext(EvaluationContext evaluationContext, Step step, Object result) {
        if (step.getName().isPresent()) {
            HashMap<String, Object> stepResult = new HashMap<String, Object>();
            if (result instanceof Result) {
                Result resultResult = (Result)result;
                stepResult.put("payload", new TypedValue(resultResult.getOutput(), DataType.builder().mediaType(resultResult.getMediaType().orElse(MediaType.ANY)).build()));
                stepResult.put("attributes", new TypedValue((Object)resultResult.getAttributes(), DataType.builder().mediaType(resultResult.getAttributesMediaType().orElse(MediaType.ANY)).build()));
            } else {
                stepResult.put("payload", result);
            }
            evaluationContext.define(step.getName().get(), TypedValue.of(stepResult));
        }
    }

    private void defineResultForNextEvaluationContext(EvaluationContext evaluationContext, Object result) {
        if (result instanceof Result) {
            Result resultResult = (Result)result;
            evaluationContext.define("payload", new TypedValue(resultResult.getOutput(), DataType.builder().mediaType(resultResult.getMediaType().orElse(MediaType.ANY)).build()));
            evaluationContext.define("attributes", new TypedValue((Object)resultResult.getAttributes(), DataType.builder().mediaType(resultResult.getAttributesMediaType().orElse(MediaType.ANY)).build()));
        } else {
            evaluationContext.define("payload", result);
        }
    }

    public static class Step {
        private final String name;
        private final DataExpression dataExpression;

        public Step(String name, DataExpression dataExpression) {
            this.name = name;
            this.dataExpression = dataExpression;
        }

        public Step(DataExpression dataExpression) {
            this(null, dataExpression);
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public DataExpression getDataExpression() {
            return this.dataExpression;
        }
    }
}

