/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.validation;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.validation.TestConnectionValidation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;

public class ConnectionValidationSettings {
    private final String testConnectionPath;
    private final ExpressionLanguage expressionLanguage;
    private final HttpConstants.Method httpMethod;
    private final Set<Integer> validStatusCodes;
    private final List<TestConnectionValidation> testConnectionValidations;
    private final MediaType responseMediaType;

    public String getTestConnectionPath() {
        return this.testConnectionPath;
    }

    public ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public HttpConstants.Method getHttpMethod() {
        return this.httpMethod;
    }

    public Set<Integer> getValidStatusCodes() {
        return this.validStatusCodes;
    }

    public List<TestConnectionValidation> getTestConnectionValidations() {
        return this.testConnectionValidations;
    }

    public MediaType getResponseMediaType() {
        return this.responseMediaType;
    }

    public static Builder builder(String testConnectionPath, ExpressionLanguage expressionLanguage) {
        return new Builder(testConnectionPath, expressionLanguage);
    }

    private ConnectionValidationSettings(Builder builder) {
        this.testConnectionPath = builder.testConnectionPath;
        this.expressionLanguage = builder.expressionLanguage;
        this.httpMethod = builder.httpMethod;
        this.validStatusCodes = builder.validStatusCodes;
        this.testConnectionValidations = builder.testConnectionValidations;
        this.responseMediaType = builder.responseMediaType;
    }

    public static class Builder {
        private String testConnectionPath;
        private ExpressionLanguage expressionLanguage;
        private HttpConstants.Method httpMethod = HttpConstants.Method.GET;
        private Set<Integer> validStatusCodes = Collections.singleton(200);
        private List<TestConnectionValidation> testConnectionValidations = new LinkedList<TestConnectionValidation>();
        private MediaType responseMediaType;

        public Builder(String testConnectionPath, ExpressionLanguage expressionLanguage) {
            this.testConnectionPath = testConnectionPath;
            this.expressionLanguage = expressionLanguage;
        }

        public Builder httpMethod(HttpConstants.Method httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder validStatusCodes(Integer ... statusCode) {
            this.validStatusCodes = new HashSet<Integer>(Arrays.asList(statusCode));
            return this;
        }

        public Builder addValidation(String validationExpression) {
            this.addValidation(validationExpression, null);
            return this;
        }

        public Builder addValidation(String validationExpression, String errorTemplateExpression) {
            this.testConnectionValidations.add(new TestConnectionValidation(validationExpression, errorTemplateExpression));
            return this;
        }

        public Builder responseMediaType(MediaType responseMediaType) {
            this.responseMediaType = responseMediaType;
            return this;
        }

        public ConnectionValidationSettings build() {
            return new ConnectionValidationSettings(this);
        }
    }
}

