/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.security.okta;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.joda.time.DateTime;
import org.mule.runtime.api.connection.ConnectionException;

public class OktaRateLimitContext {
    private HttpResponse httpResponse;

    public OktaRateLimitContext(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public long getNumRequestsRemaining() throws ConnectionException {
        return this.getHeaderValueLong("X-Rate-Limit-Remaining");
    }

    public long getNextWindowUnixTime() throws ConnectionException {
        return this.getHeaderValueLong("X-Rate-Limit-Reset");
    }

    public DateTime getNextWindowDateTime() throws ConnectionException {
        Long unixTime = this.getNextWindowUnixTime();
        try {
            return new DateTime(unixTime * 1000L);
        }
        catch (Exception e) {
            String message = "Unable to convert X-Rate-Limit-Reset to DateTime";
            throw new ConnectionException(message, (Throwable)e);
        }
    }

    public Long getRequestLimit() throws ConnectionException {
        return this.getHeaderValueLong("X-Rate-Limit-Limit");
    }

    private String getHeaderValueString(String headerName) throws ConnectionException {
        if (this.httpResponse == null) {
            String message = "No http response";
            throw new ConnectionException(message);
        }
        Header[] headers = this.httpResponse.getHeaders(headerName);
        if (headers.length > 0) {
            Header header = headers[0];
            return header.getValue();
        }
        String message = "No " + headerName + " header";
        throw new ConnectionException(message);
    }

    private long getHeaderValueLong(String headerName) throws ConnectionException {
        String headerString = this.getHeaderValueString(headerName);
        try {
            return Long.parseLong(headerString);
        }
        catch (Exception e) {
            String message = "Error parsing " + headerName + " header";
            throw new ConnectionException(message, (Throwable)e);
        }
    }
}

