/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.security;

import com.mulesoft.connectors.sharepoint.internal.service.handler.FoundResponseHandler;
import com.mulesoft.connectors.sharepoint.internal.service.security.ClaimsLogin;
import com.mulesoft.connectors.sharepoint.internal.service.security.KerberosLogin;
import com.mulesoft.connectors.sharepoint.internal.service.security.NtlmLogin;
import com.mulesoft.connectors.sharepoint.internal.service.security.OktaLoginResult;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaAuthApiClient;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaClientConfiguration;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.models.AuthResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationException;
import org.mule.modules.security.microsoft.adfs.AdfsAuthentication;
import org.mule.modules.security.microsoft.microsoftonline.MicrosoftOnlineAuthentication;
import org.mule.modules.security.microsoft.utils.SamlTokenUtils;
import org.mule.runtime.api.connection.ConnectionException;

public class LoginService {
    public static final String INVALID_OKTA_ACCOUNT = "Could not log into Sharepoint with this user. Please check your Okta account.";
    public static final String UNABLE_TO_FETCH_SHAREPOINT_INSTANCE_URL = "Unable to fetch sharepoint instance URL";
    private static final String WCTX = "wctx";
    private static final int VALID_AUTH_PAYLOAD = 2;
    private final CloseableHttpClient httpClient;

    public LoginService(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public OktaLoginResult login(String sharepointEmbededLink, String username, String password, String oktaUrl, String oktaApiToken) throws ConnectionException {
        OktaClientConfiguration oktaClientConfiguration = new OktaClientConfiguration(oktaUrl, oktaApiToken);
        OktaAuthApiClient authClient = new OktaAuthApiClient(oktaClientConfiguration);
        AuthResult authResult = authClient.authenticate(username, password, "");
        Map<String, String> authPayload = authClient.getSAMLArguments(sharepointEmbededLink, authResult.getSessionToken());
        if (authPayload.size() < 2) {
            throw new ConnectionException(INVALID_OKTA_ACCOUNT);
        }
        String token = authClient.getSAMLToken(authPayload);
        String siteUrlFromOkta = this.getSiteUrlFromOkta(authPayload.get(WCTX));
        return new OktaLoginResult(this.convertStringToURL(siteUrlFromOkta), this.getHttpContextWithAccessToken(siteUrlFromOkta, token));
    }

    private URL convertStringToURL(String urlAsString) throws ConnectionException {
        try {
            return new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException(UNABLE_TO_FETCH_SHAREPOINT_INSTANCE_URL, (Throwable)e);
        }
    }

    private String getSiteUrlFromOkta(String wctxOutput) throws ConnectionException {
        String decodedURL;
        try {
            decodedURL = URLDecoder.decode(wctxOutput, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        return decodedURL.substring(decodedURL.indexOf("wreply=") + 7, decodedURL.indexOf("_layouts/15/sharepoint.aspx"));
    }

    public HttpContext login(URL serviceUrl, String username, String password) throws ConnectionException {
        try {
            MicrosoftOnlineAuthentication microsoftOnlineAuthentication = new MicrosoftOnlineAuthentication(this.httpClient);
            String securityTokenRequestResponse = microsoftOnlineAuthentication.getSecurityTokenForSharepointOnline(username, password, serviceUrl, 1);
            String requestedSecurityToken = SamlTokenUtils.getRequestedSecurityTokenFromSecurityTokenResponse((String)securityTokenRequestResponse);
            String token = SamlTokenUtils.getValueFromXml((String)requestedSecurityToken, (String)"BinarySecurityToken");
            String baseSite = serviceUrl.toString().substring(0, serviceUrl.toString().length() - serviceUrl.getPath().length());
            return this.getHttpContextWithAccessToken(baseSite, token);
        }
        catch (MicrosoftAuthenticationException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public HttpContext login(ClaimsLogin claimsLogin) throws ConnectionException {
        try {
            AdfsAuthentication adfsAuthentication = new AdfsAuthentication(this.httpClient);
            String securityTokenRequestResponse = adfsAuthentication.getTokenFromAdfs(claimsLogin.getUsername(), claimsLogin.getPassword(), claimsLogin.getScope(), claimsLogin.getStsUrl());
            String wresult = SamlTokenUtils.getValueFromXml((String)securityTokenRequestResponse, (String)"Body");
            URL serviceUrl = claimsLogin.getServiceUrl();
            String baseSite = serviceUrl.toString().substring(0, serviceUrl.toString().length() - serviceUrl.getPath().length());
            return this.getHttpContextWithAccessToken(baseSite, wresult);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private HttpContext getHttpContextWithAccessToken(String baseWSSignUrl, String token) throws ConnectionException {
        try {
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
            HttpPost postTokenToSharepointForLogingIn = new HttpPost(baseWSSignUrl + "/_forms/default.aspx?wa=wsignin1.0");
            postTokenToSharepointForLogingIn.setHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)");
            postTokenToSharepointForLogingIn.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
            postTokenToSharepointForLogingIn.setEntity((HttpEntity)new StringEntity(token));
            this.httpClient.execute((HttpUriRequest)postTokenToSharepointForLogingIn, (ResponseHandler)new FoundResponseHandler(), (HttpContext)httpContext);
            return httpContext;
        }
        catch (IOException e) {
            throw new ConnectionException("Unable to obtain access token.", (Throwable)e);
        }
    }

    public HttpContext login(NtlmLogin ntlmLogin) {
        BasicHttpContext httpContext = new BasicHttpContext();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(ntlmLogin.getUsername(), ntlmLogin.getPassword(), "", ntlmLogin.getDomain()));
        httpContext.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
        return httpContext;
    }

    public HttpContext login(URL serviceUrl, String securityToken) throws ConnectionException {
        try {
            String baseSite = serviceUrl.toString().substring(0, serviceUrl.toString().length() - serviceUrl.getPath().length());
            String extractedToken = securityToken.contains("wsse:BinarySecurityToken") ? SamlTokenUtils.getValueFromXml((String)securityToken, (String)"BinarySecurityToken") : securityToken;
            return this.getHttpContextWithAccessToken(baseSite, extractedToken);
        }
        catch (MicrosoftAuthenticationException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public HttpContext login(KerberosLogin kerberosLogin) {
        HttpClientContext httpClientContext = HttpClientContext.create();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(kerberosLogin.getUsername(), kerberosLogin.getPassword()));
        httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        return httpClientContext;
    }
}

