/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.paging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class GraphCycleDetection<T>
implements Iterable<T> {
    private final Map<T, Map<T, Double>> graph = new HashMap<T, Map<T, Double>>();

    public boolean addNode(T node) {
        if (node == null) {
            throw new NullPointerException("The input node cannot be null.");
        }
        if (this.graph.containsKey(node)) {
            return false;
        }
        this.graph.put(node, new HashMap());
        return true;
    }

    public void addEdge(T source, T destination, double length) {
        if (source == null || destination == null) {
            throw new NullPointerException("Source and Destination, both should be non-null.");
        }
        if (!this.graph.containsKey(source) || !this.graph.containsKey(destination)) {
            throw new NoSuchElementException("Source and Destination, both should be part of graph");
        }
        if (this.isReachable(source, destination)) {
            throw new IllegalArgumentException("Cannot add this edge because it would create a cycle");
        }
        this.graph.get(source).put(destination, length);
    }

    public void removeEdge(T source, T destination) {
        if (source == null || destination == null) {
            throw new NullPointerException("Source and Destination, both should be non-null.");
        }
        if (!this.graph.containsKey(source) || !this.graph.containsKey(destination)) {
            throw new NoSuchElementException("Source and Destination, both should be part of graph");
        }
        this.graph.get(source).remove(destination);
    }

    public Map<T, Double> edgesFrom(T node) {
        if (node == null) {
            throw new NullPointerException("The node should not be null.");
        }
        Map<T, Double> edges = this.graph.get(node);
        if (edges == null) {
            throw new NoSuchElementException("Source node does not exist.");
        }
        return Collections.unmodifiableMap(edges);
    }

    @Override
    public Iterator<T> iterator() {
        return this.graph.keySet().iterator();
    }

    private boolean isReachable(T target, T from) {
        if (target.equals(from)) {
            return true;
        }
        for (T nxt : this.graph.get(from).keySet()) {
            if (!this.isReachable(target, nxt)) continue;
            return true;
        }
        return false;
    }
}

