/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations;

import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataManager;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListField;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListMetadataResolver
implements QueryEntityResolver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractListMetadataResolver.class);

    public Set<MetadataKey> getListNames(SharepointService client) {
        String filterQuery = "Hidden eq false";
        String selectQuery = "Title,Id";
        return client.getLists("$filter=" + filterQuery + "&$select=" + selectQuery).stream().map(list -> MetadataKeyBuilder.newKey((String)list.getId()).withDisplayName(list.getTitle()).build()).collect(Collectors.toSet());
    }

    public MetadataType describeOutputListColumns(String metadataKey, MetadataManager manager) {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(JavaTypeLoader.JAVA);
        ObjectTypeBuilder dynamicObjectBuilder = typeBuilder.objectType().id(metadataKey);
        try {
            for (SharepointListField field : this.getFields(metadataKey, manager)) {
                this.createOutputMetadata(dynamicObjectBuilder, field);
            }
            return dynamicObjectBuilder.build();
        }
        catch (SharepointException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return dynamicObjectBuilder.addField().key("Object").value().objectType().id("Object").build();
        }
    }

    private void createOutputMetadata(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        if (field.isMultiChoiceField()) {
            Boolean isReadOnlyField = field.getReadOnlyField();
            if (Boolean.FALSE.equals(isReadOnlyField)) {
                BaseTypeBuilder typeBuilder = new BaseTypeBuilder(JavaTypeLoader.JAVA);
                dynamicObjectBuilder.addField().key(field.getTitle()).value().arrayType().of((TypeBuilder)typeBuilder.stringType().id(field.getTitle()));
            }
        } else {
            Integer fieldTypeKind = field.getFieldTypeKind();
            if (field.isCalculatedField()) {
                fieldTypeKind = field.getOutputType() != null ? field.getOutputType() : Integer.valueOf(2);
            }
            field.setFieldTypeKind(fieldTypeKind);
            this.addListFieldToBuilder(dynamicObjectBuilder, field);
        }
    }

    private void addListFieldToBuilder(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        switch (field.getFieldTypeKind()) {
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 31: {
                this.addNumberFieldToBuilder(dynamicObjectBuilder, field);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                this.addStringFieldToBuilder(dynamicObjectBuilder, field);
                break;
            }
            case 4: {
                this.addDateTimeFieldToBuilder(dynamicObjectBuilder, field);
                break;
            }
            case 8: 
            case 19: 
            case 29: {
                this.addBooleanFieldToBuilder(dynamicObjectBuilder, field);
                break;
            }
            default: {
                this.addObjectFieldToBuilder(dynamicObjectBuilder, field);
            }
        }
    }

    private void addObjectFieldToBuilder(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        dynamicObjectBuilder.addField().key(field.getTitle()).value().objectType().id(field.getTitle());
    }

    private void addBooleanFieldToBuilder(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        dynamicObjectBuilder.addField().key(field.getTitle()).value().booleanType().id(field.getTitle());
    }

    private void addDateTimeFieldToBuilder(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        dynamicObjectBuilder.addField().key(field.getTitle()).value().dateTimeType().id(field.getTitle());
    }

    private void addStringFieldToBuilder(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        dynamicObjectBuilder.addField().key(field.getTitle()).value().stringType().id(field.getTitle());
    }

    private void addNumberFieldToBuilder(ObjectTypeBuilder dynamicObjectBuilder, SharepointListField field) {
        dynamicObjectBuilder.addField().key(field.getTitle()).value().numberType().id(field.getTitle());
    }

    protected List<SharepointListField> getFields(String metadataKey, MetadataManager manager) {
        return manager.getFields(metadataKey);
    }
}

