/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.KeyStoreType;
import com.mulesoft.connectors.sharepoint.internal.connection.OAuthClientCredentialsConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.AssertionGenerator;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.SimpleObjectStoreToMapAdapter;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer.ClientCredentialsOauthDancer;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer.ClientCredentialsOauthDancerBuilder;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.oauth.api.http.HttpClientFactory;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="oauth-client-credentials")
@DisplayName(value="OAuth Client Credentials")
public class OAuthClientCredentialsGrantTypeConnectionProvider
extends AbstractSharepointConnectionProvider {
    private static final String NO_CLIENT_SECRET = "NO_CLIENT_SECRET";
    private static final Logger logger = LoggerFactory.getLogger(OAuthClientCredentialsGrantTypeConnectionProvider.class);
    @RefName
    private String configName;
    @Parameter
    @DisplayName(value="Client ID")
    @Summary(value="The client ID to call the API.")
    private String clientId;
    @Parameter
    @DisplayName(value="Token URL")
    @Example(value="https://login.microsoftonline.com/{tenant}/oauth2/v2.0/token")
    @Summary(value="The URL used for getting an access token.")
    private String tokenUrl;
    @Parameter
    @Optional
    @DisplayName(value="Scopes")
    @Summary(value="Defined scopes for client ID.")
    private String scope;
    @Parameter
    @DisplayName(value="Keystore alias")
    @Summary(value="The alias used for getting correct certificate from keystore.")
    protected String keyStoreAlias;
    @Parameter
    @DisplayName(value="Path to keystore")
    @Summary(value="The path to client's keystore with private key and certificate.")
    protected String keyStorePath;
    @Parameter
    @DisplayName(value="Keystore password")
    @Summary(value="The password used for accessing the private key from the keystore.")
    @Password
    protected String keyStorePassword;
    @Parameter
    @DisplayName(value="Keystore type")
    @Summary(value="The keystore type. There are 3 types supported: JCEKS, JKS, PKCS12.")
    protected KeyStoreType keyStoreType;
    @Parameter
    @DisplayName(value="Key password")
    @Summary(value="The password used to protect the private key.")
    @Password
    @Optional
    protected String keyPassword;
    @Parameter
    @Optional
    @ObjectStoreReference
    private ObjectStore objectStore;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    protected HttpService httpService;
    private ClientCredentialsOauthDancer dancer;

    public String getConfigName() {
        return this.configName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getScope() {
        return this.scope;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public KeyStoreType getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setDancer(ClientCredentialsOauthDancer dancer) {
        this.dancer = dancer;
    }

    public SharepointConnection connect() throws ConnectionException {
        try {
            logger.debug("Creating Client Credentials Oauth2 connection");
            if (this.dancer == null) {
                AssertionGenerator assertionGenerator = new AssertionGenerator(this.getKeyStorePath(), this.getKeyStorePassword(), this.getKeyStoreAlias(), this.getKeyStoreType(), this.getKeyPassword(), this.getClientId(), this.getTokenUrl());
                ClientCredentialsOauthDancerBuilder builder = new ClientCredentialsOauthDancerBuilder(this.schedulerService, obj -> new ReentrantLock(true), (Map<String, ResourceOwnerOAuthContext>)((Object)new SimpleObjectStoreToMapAdapter(this.objectStore)), HttpClientFactory.getDefault((HttpService)this.httpService), null);
                this.dancer = (ClientCredentialsOauthDancer)((Object)builder.assertionGenerator(assertionGenerator).clientCredentials(this.getClientId(), NO_CLIENT_SECRET).tokenUrl(this.getTokenUrl()).scopes(this.getScope()).build());
            }
            logger.debug("Successfully created ClientCredentialsOauthDancer");
            logger.debug("Initialising OAuth dancer");
            LifecycleUtils.initialiseIfNeeded((Object)((Object)this.dancer));
            LifecycleUtils.startIfNeeded((Object)((Object)this.dancer));
            logger.debug("Successfully created OAuth connection");
            return new OAuthClientCredentialsConnection(this.httpClient, this.dancer, this.getSiteUrl());
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.objectStore == null) {
            logger.info("No objectStore reference provided. Creating objectStore for token management.");
            ObjectStoreSettings settings = ObjectStoreSettings.builder().persistent(true).build();
            this.objectStore = this.objectStoreManager.createObjectStore("token-manager-store-" + this.getConfigName(), settings);
            logger.debug("Successfully created objectStore");
        }
    }
}

