/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer;

import com.mulesoft.connectors.sharepoint.internal.connection.oauth.AssertionGenerator;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.SharepointBearerAssertionListener;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer.ClientCredentialsConfig;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.mapper.impl.ObjectMapperBasedMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.oauth.internal.AbstractOAuthDancer;
import org.mule.runtime.oauth.internal.config.OAuthDancerConfig;
import org.mule.runtime.oauth.internal.state.TokenResponse;
import org.mule.runtime.oauth.internal.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsOauthDancer
extends AbstractOAuthDancer<ClientCredentialsConfig> {
    private static final String ASSERTION_TYPE = "client_assertion_type";
    private static final String ASSERTION = "client_assertion";
    private static final int RESPONSE_TIMEOUT_IN_MILLIS = 60000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCredentialsOauthDancer.class);
    private boolean accessTokenRefreshedOnStart = false;
    private final ObjectMapperBasedMapper objectMapper = ObjectMapperBasedMapper.getInstance();
    private Instant timeOfExpiration;

    public ClientCredentialsOauthDancer(ClientCredentialsConfig config) {
        super((OAuthDancerConfig)config);
    }

    public void start() throws MuleException {
        super.start();
        this.refreshToken().join();
        this.accessTokenRefreshedOnStart = true;
    }

    public CompletableFuture<String> accessToken() {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        String accessToken = this.getContext().getAccessToken();
        if (Instant.now().isAfter(this.timeOfExpiration)) {
            LOGGER.info("Previously stored token soon expires. Refreshing...");
            return this.doRefreshTokenRequest(false).thenApply(v -> this.getContext().getAccessToken());
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshTokenRequest(true);
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners) {
        return this.doRefreshToken(this::getContext, ctx -> this.doRefreshTokenRequest(notifyListeners, (ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners, ResourceOwnerOAuthContextWithRefreshState state) {
        return ((CompletableFuture)this.invokeTokenUrl(((ClientCredentialsConfig)this.config).getTokenUrl(), Collections.emptyMap(), (MultiMap<String, String>)MultiMap.emptyMultiMap(), (MultiMap<String, String>)MultiMap.emptyMultiMap(), null, false, ((ClientCredentialsConfig)this.config).getEncoding()).thenAccept((Consumer)this.getTokenResponseConsumer(notifyListeners, state))).exceptionally(this.tokenUrlExceptionHandler((ResourceOwnerOAuthContext)state));
    }

    private Consumer<TokenResponse> getTokenResponseConsumer(boolean notifyListeners, ResourceOwnerOAuthContextWithRefreshState state) {
        return resp -> {
            ClientCredentialsOauthDancer.setContextClassLoaderHelperMethod();
            try {
                LOGGER.debug("Retrieved access token and expires are: {},  {}", (Object)resp.getAccessToken(), (Object)resp.getExpiresIn());
                state.setAccessToken(resp.getAccessToken());
                this.timeOfExpiration = Instant.now().plusSeconds(Long.parseLong(resp.getExpiresIn()) - 30L);
                this.updateOAuthContextAfterTokenResponse((ResourceOwnerOAuthContext)state);
                if (notifyListeners) {
                    this.forEachListener(l -> l.onTokenRefreshed((ResourceOwnerOAuthContext)state));
                }
            }
            finally {
                ClientCredentialsOauthDancer.setContextClassLoaderHelperMethod();
            }
        };
    }

    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }

    private void forEachListener(Consumer<SharepointBearerAssertionListener> action) {
        this.onEachListener(listener -> action.accept((SharepointBearerAssertionListener)listener));
    }

    protected CompletableFuture<TokenResponse> invokeTokenUrl(String tokenUrl, Map<String, String> params, MultiMap<String, String> queryParams, MultiMap<String, String> headers, String authorization, boolean retrieveRefreshToken, Charset encoding) {
        HashMap<String, String> tokenRequestBody = new HashMap<String, String>();
        tokenRequestBody.put("client_id", ((ClientCredentialsConfig)this.config).getClientId());
        tokenRequestBody.put("grant_type", "client_credentials");
        tokenRequestBody.put("scope", ((ClientCredentialsConfig)this.config).getScopes());
        AssertionGenerator assertionGenerator = ((ClientCredentialsConfig)this.config).getAssertionGenerator();
        tokenRequestBody.put(ASSERTION_TYPE, assertionGenerator.getAssertionType());
        tokenRequestBody.put(ASSERTION, assertionGenerator.generate());
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(tokenUrl).method(HttpConstants.Method.POST.name()).entity((HttpEntity)new ByteArrayHttpEntity(HttpEncoderDecoderUtils.encodeString(tokenRequestBody, (Charset)encoding).getBytes()))).addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())).queryParams(queryParams).headers(headers);
        return ((ClientCredentialsConfig)this.config).getHttpClient().sendAsync(requestBuilder.build(), HttpRequestOptions.builder().responseTimeout(60000).build()).thenApply(response -> this.parseTokenResponse((HttpResponse)response, tokenUrl, retrieveRefreshToken));
    }

    /*
     * Exception decompiling
     */
    protected TokenResponse parseTokenResponse(HttpResponse response, String tokenUrl, boolean retrieveRefreshToken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setContextClassLoaderHelperMethod() {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassLoader contextClassLoader = AbstractOAuthDancer.class.getClassLoader();
        ClassLoaderUtils.setContextClassLoader((Thread)thread, (ClassLoader)currentClassLoader, (ClassLoader)contextClassLoader);
    }

    private static void handleBadRequest(HttpResponse response, String tokenUrl, String body) {
        try {
            throw new CompletionException((Throwable)new TokenUrlResponseException(tokenUrl, response, body));
        }
        catch (IOException e) {
            throw new CompletionException((Throwable)new TokenUrlResponseException(tokenUrl, (Exception)e));
        }
    }
}

