/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.oauth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.mulesoft.connectors.sharepoint.api.KeyStoreType;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import org.mule.runtime.core.api.util.StringUtils;

public class AssertionGenerator {
    private static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private static final String SHA_1 = "SHA-1";
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyStoreAlias;
    private final KeyStoreType keyStoreType;
    private final String keyPassword;
    private final String clientId;
    private final String tokenUrl;

    public AssertionGenerator(String keyStorePath, String keyStorePassword, String keyStoreAlias, KeyStoreType type, String keyPassword, String clientId, String tokenUrl) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = type;
        this.keyPassword = StringUtils.isBlank((String)keyPassword) ? keyStorePassword : keyPassword;
        this.clientId = clientId;
        this.tokenUrl = tokenUrl;
    }

    public String generate() {
        try {
            KeyStore keystore = KeyStore.getInstance(this.keyStoreType.name());
            keystore.load(this.getStream(), this.keyStorePassword.toCharArray());
            Certificate cert = keystore.getCertificate(this.keyStoreAlias);
            RSAPrivateKey privateKey = (RSAPrivateKey)keystore.getKey(this.keyStoreAlias, this.keyPassword.toCharArray());
            HashMap<String, String> jwtHeaders = new HashMap<String, String>();
            jwtHeaders.put("alg", "RS256");
            jwtHeaders.put("typ", "JWT");
            jwtHeaders.put("x5t", Base64.getEncoder().encodeToString(MessageDigest.getInstance(SHA_1).digest(cert.getEncoded())));
            ZonedDateTime now = ZonedDateTime.now();
            return JWT.create().withHeader(jwtHeaders).withAudience(new String[]{this.tokenUrl}).withExpiresAt(now.plusMinutes(5L).toInstant()).withIssuer(this.clientId).withJWTId(UUID.randomUUID().toString()).withNotBefore(now.toInstant()).withSubject(this.clientId).withIssuedAt(now.toInstant()).sign(Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)cert.getPublicKey()), (RSAPrivateKey)privateKey));
        }
        catch (Exception e) {
            throw new SharepointValidationException("Failed to generate the JWT assertion.", e);
        }
    }

    private InputStream getStream() throws IOException {
        try {
            return Files.newInputStream(Paths.get(this.keyStorePath, new String[0]), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            if (this.getClass().getClassLoader().getResource(this.keyStorePath) == null) {
                throw new SharepointException("Path to keystore is empty.");
            }
            return this.getClass().getClassLoader().getResourceAsStream(this.keyStorePath);
        }
    }

    public String getAssertionType() {
        return CLIENT_ASSERTION_TYPE;
    }
}

