/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.valueprovider.operators;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.operation.CloudHubOperations;
import com.mulesoft.connectors.cloudhub.internal.operation.utils.StatisticsInformation;
import com.mulesoft.connectors.cloudhub.internal.valueprovider.BaseValueProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class DomainsValueProvider
extends BaseValueProvider {
    private static final String EXPRESSION = "%dw 2.0\noutput application/java\n---\npayload map ((val, key) -> {\n    \"$(val.domain)\" : val.domain\n} ) reduce ($$ ++ $)";
    @Connection
    private CloudHubConnection cloudHubConnection;

    public Set<Value> resolve() throws ValueResolvingException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Reference valuesReference = new Reference(new HashSet());
        Reference throwableReference = new Reference();
        new CloudHubOperations().listApplications(this.cloudHubConnection, new StatisticsInformation(false, 0, TimeUnit.HOURS), false, false, false, this.createCallbackHandler(countDownLatch, (Reference<Set<Value>>)valuesReference, (Reference<Throwable>)throwableReference, EXPRESSION));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)e);
        }
        if (throwableReference.get() != null) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)throwableReference.get());
        }
        return (Set)valuesReference.get();
    }
}

