/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.operation.utils;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubClientCredentialsConnection;
import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubException;
import java.util.function.Consumer;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class RetryCompletionCallback<P, A>
implements CompletionCallback<P, A> {
    private Consumer<CompletionCallback<P, A>> runnable;
    private CompletionCallback<P, A> completionCallback;
    private int counter = 0;
    private final int retries;
    private final CloudHubConnection connection;

    public RetryCompletionCallback(Consumer<CompletionCallback<P, A>> runnable, CompletionCallback<P, A> completionCallback, CloudHubConnection connection, int retries) {
        this.runnable = runnable;
        this.completionCallback = completionCallback;
        this.connection = connection;
        this.retries = retries;
    }

    public void success(Result<P, A> result) {
        this.completionCallback.success(result);
    }

    public void error(Throwable e) {
        try {
            if (this.isRetryableError(e)) {
                if (this.connection instanceof CloudHubClientCredentialsConnection && ((CloudHubClientCredentialsConnection)this.connection).isTokenExpired()) {
                    ((CloudHubClientCredentialsConnection)this.connection).refreshToken();
                }
                ++this.counter;
                this.runnable.accept(this);
            } else {
                this.completionCallback.error(e);
            }
        }
        catch (Exception ex) {
            this.completionCallback.error(e);
        }
    }

    private boolean isRetryableError(Throwable e) {
        if (this.counter < this.retries && e instanceof CloudHubException) {
            int statusCode = ((CloudHubException)((Object)e)).getStatusCode();
            boolean clientCredentialsRetryable = this.connection instanceof CloudHubClientCredentialsConnection && (statusCode == 401 || statusCode == 403 && ((CloudHubClientCredentialsConnection)this.connection).isTokenExpired() && this.counter == 0);
            return statusCode == 500 || clientCredentialsRetryable;
        }
        return false;
    }

    public void execute() {
        this.runnable.accept(this);
    }
}

