/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.core.version.comparator;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModifierComparator
implements Comparator<String> {
    public static final String SNAPSHOT = "-";
    public static final String RELEASE = "";
    public static final String DATE = "-DATE";
    public static final String HF = "-hf";
    public static final String HFx = "-hfX";
    private final Pattern numberPattern = Pattern.compile("\\d+");
    private final Pattern chPattern = Pattern.compile("-[0-9]{8}");
    private final Map<String, Integer> indexes = new HashMap<String, Integer>();

    public ModifierComparator() {
        this.indexes.put(SNAPSHOT, 0);
        this.indexes.put("-ea", 1);
        this.indexes.put("-rc", 2);
        this.indexes.put(RELEASE, 3);
        this.indexes.put(HFx, 4);
        this.indexes.put(DATE, 5);
        this.indexes.put(HF, 6);
    }

    @Override
    public int compare(String aModifier, String anotherModifier) {
        String anotherCleanModifier;
        String aCleanModifier = this.cleanUp(aModifier);
        int keyAvailables = this.keyAvailables(aCleanModifier, anotherCleanModifier = this.cleanUp(anotherModifier));
        if (keyAvailables != 0) {
            return keyAvailables;
        }
        int modifierComparison = this.indexes.get(aCleanModifier) - this.indexes.get(anotherCleanModifier);
        if (modifierComparison == 0) {
            modifierComparison = this.number(aModifier) - this.number(anotherModifier);
        }
        return modifierComparison;
    }

    private String cleanUp(String aModifier) {
        boolean isDate = this.chPattern.matcher(aModifier).matches();
        if (isDate) {
            return DATE;
        }
        String modSubString = aModifier.substring(0, this.numberIndex(aModifier));
        if (modSubString.equals(HF)) {
            return modSubString.length() == aModifier.length() ? HF : HFx;
        }
        return modSubString;
    }

    private int number(String aModifier) {
        String stringNumber = this.numberAsString(aModifier);
        return stringNumber != null ? Integer.parseInt(stringNumber) : 0;
    }

    private int numberIndex(String aModifier) {
        String numberAsString = this.numberAsString(aModifier);
        int numberLength = numberAsString != null ? numberAsString.length() : 0;
        return aModifier.length() - numberLength;
    }

    private String numberAsString(String s) {
        Matcher m = this.numberPattern.matcher(s);
        return m.find() ? m.group() : null;
    }

    private int keyAvailables(String aCleanModifier, String anotherCleanModifier) {
        if (this.indexes.containsKey(aCleanModifier)) {
            if (!this.indexes.containsKey(anotherCleanModifier)) {
                return 1;
            }
        } else {
            if (this.indexes.containsKey(anotherCleanModifier)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

