/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionBuilder;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.detection.PolicyChangeProcessor;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DefaultPolicySetDeploymentService
implements PolicySetDeploymentService {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultPolicySetDeploymentService.class);
    private final RunnableRetrier<ApiKey> runnableRetrier;
    private MultiplexingPolicyDeploymentService policyDeploymentService;
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final PolicyStore policyStore;
    private final PolicyTemplateStore policyTemplateStore;
    private final List<PolicySetDeploymentListener> deploymentListeners = new CopyOnWriteArrayList<PolicySetDeploymentListener>();
    private final ApiService apiService;

    public DefaultPolicySetDeploymentService(RunnableRetrier<ApiKey> policySetRetrier, MultiplexingPolicyDeploymentService policyDeploymentService, PolicyDeploymentTracker policyDeploymentTracker, PolicyStore policyStore, PolicyTemplateStore policyTemplateStore, ApiService apiService) {
        this.runnableRetrier = policySetRetrier;
        this.policyDeploymentService = policyDeploymentService;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyStore = policyStore;
        this.policyTemplateStore = policyTemplateStore;
        this.apiService = apiService;
    }

    @Override
    public synchronized void policiesForApi(ApiKey apiKey, PolicySet policySet) {
        PolicySet apiPolicySet = this.apiPolicySet(apiKey, policySet);
        this.runnableRetrier.scheduleRetry((Object)apiKey, () -> {
            this.logPoliciesForApi(apiKey, apiPolicySet);
            new PolicyChangeProcessor(this.policyDeploymentService).process(this.policyDeploymentTracker.onlinePolicyStatuses(apiKey), apiPolicySet.getPolicyDefinitions());
            if (this.failedDownloadTemplates(apiKey).size() != 0) {
                LOGGER.debug("Template download failed for API {} - Policies {}.", (Object)apiKey, this.names(this.failedDownloadTemplates(apiKey)));
                throw new RuntimeException("There are still failures in template downloading");
            }
            this.notifyPolicySetDeployed(apiKey, apiPolicySet);
        });
    }

    @Override
    public void removeAll(ApiKey apiKey) {
        LOGGER.debug("Removing all policies from API {}", (Object)apiKey);
        this.notifyAllPoliciesRemoved(apiKey);
        List<PolicyDefinition> policiesToRemove = this.policyDeploymentTracker.apiRemoved(apiKey);
        policiesToRemove.forEach(this.policyDeploymentService::removePolicy);
    }

    public void onApiDeploymentSuccess(Api api) {
        this.policyStore.offlinePolicies().stream().filter(policyDefinition -> policyDefinition.getApiKeys().contains(api.getKey())).forEach(policyDefinition -> this.policyDeploymentService.newPolicy(this.specializeToApi(api.getKey(), (PolicyDefinition)policyDefinition)));
    }

    public void onApiUndeploymentStart(ApiImplementation implementation) {
        this.removeAll(implementation.getApiKey());
    }

    public void onApiRedeploymentStart(ApiImplementation implementation) {
        this.notifyAllPoliciesRemoved(implementation.getApiKey());
        this.policyDeploymentTracker.apiRemoved(implementation.getApiKey());
    }

    @Override
    public void addPolicyDeploymentListener(PolicySetDeploymentListener listener) {
        this.deploymentListeners.add(listener);
    }

    @Override
    public void conciliatePolicies(ApiKey apiKey, List<PolicyDefinition> desiredPolicies) {
        List<PolicyDefinition> actualPolicies = this.filterByApi(this.policyStore.onlinePolicies(), apiKey);
        actualPolicies.stream().filter(policyDefinition -> !desiredPolicies.contains(policyDefinition)).forEach(policyDefinition -> this.policyStore.remove(policyDefinition.getName()));
        desiredPolicies.stream().filter(policyDefinition -> !actualPolicies.contains(policyDefinition)).forEach(policyDefinition -> this.policyStore.store((PolicyDefinition)policyDefinition));
    }

    @Override
    public void cleanUnusedTemplates() {
        List usedTemplateNames = this.policyStore.load().stream().map(policyDefinition -> policyDefinition.getTemplateKey().getName()).distinct().collect(Collectors.toList());
        this.policyTemplateStore.getAllTemplateAssets().stream().filter(assets -> !usedTemplateNames.contains(assets.getTemplateName())).forEach(PolicyTemplateAssets::delete);
    }

    @Override
    public Map<ApiKey, List<PolicyDefinition>> storedOnlinePoliciesByApi() {
        HashMap<ApiKey, List<PolicyDefinition>> groupedPolicies = new HashMap<ApiKey, List<PolicyDefinition>>();
        this.policyStore.onlinePolicies().forEach(policyDefinition -> policyDefinition.getApiKeys().forEach(apiKey -> {
            groupedPolicies.putIfAbsent((ApiKey)apiKey, new ArrayList());
            ((List)groupedPolicies.get(apiKey)).add(policyDefinition);
        }));
        return groupedPolicies;
    }

    private PolicySet apiPolicySet(ApiKey apiKey, PolicySet policySet) {
        List apiDefinitions = policySet.getPolicyDefinitions().stream().filter(definition -> definition.getApiKeys().contains(apiKey)).map(definition -> this.specializeToApi(apiKey, (PolicyDefinition)definition)).collect(Collectors.toList());
        return new PolicySet(apiDefinitions, policySet.getOrigin());
    }

    private PolicyDefinition specializeToApi(ApiKey apiKey, PolicyDefinition definition) {
        return new PolicyDefinitionBuilder(definition).apiKey(apiKey).build();
    }

    private void logPoliciesForApi(ApiKey apiKey, PolicySet policySet) {
        if (LOGGER.isDebugEnabled()) {
            List policyNames = policySet.getPolicyDefinitions().stream().map(PolicyDefinition::getName).collect(Collectors.toList());
            LOGGER.debug("Deploying policies {} from {} to API {}", new Object[]{policyNames, policySet.isFromPlatform() ? "Platform" : "File System", apiKey});
        }
    }

    private void notifyAllPoliciesRemoved(ApiKey apiKey) {
        this.deploymentListeners.forEach(policyDeploymentListener -> {
            try {
                policyDeploymentListener.onPoliciesRemoved(apiKey);
            }
            catch (Exception e) {
                LOGGER.warn("Error on polices removed listener: {}", (Object)e.getMessage());
            }
        });
    }

    private void notifyPolicySetDeployed(ApiKey apiKey, PolicySet policySet) {
        this.deploymentListeners.forEach(policyDeploymentListener -> {
            try {
                policyDeploymentListener.onPolicySetDeploymentCompleted(apiKey, policySet, this.policyDeploymentTracker.onlinePolicyStatuses(apiKey).stream().map(PolicyDeploymentStatus::getLatestPolicyStatus).collect(Collectors.toList()));
            }
            catch (Exception e) {
                LOGGER.warn("Error on policy deployment completed listener: {}", (Object)e.getMessage());
            }
        });
    }

    private List<PolicyDefinition> filterByApi(List<PolicyDefinition> policyDefinitions, ApiKey apiKey) {
        return policyDefinitions.stream().filter(policyDefinition -> policyDefinition.getApiKeys().contains(apiKey)).collect(Collectors.toList());
    }

    private List<String> names(List<PolicyDefinitionDeploymentStatus> policyDeploymentStatuses) {
        return policyDeploymentStatuses.stream().map(status -> status.getPolicyDefinition().getName()).collect(Collectors.toList());
    }

    private List<PolicyDefinitionDeploymentStatus> failedDownloadTemplates(ApiKey apiKey) {
        return this.policyDeploymentTracker.onlinePolicyStatuses(apiKey).stream().map(PolicyDeploymentStatus::getLatestPolicyStatus).filter(PolicyDefinitionDeploymentStatus::isTemplateDownloadFailed).collect(Collectors.toList());
    }
}

