/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck.ReadyStatusFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck.TextReadyStatusFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.healthcheck.HealthCheckValidator;
import org.mule.runtime.api.healthcheck.ReadyStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHealthCheck.class);
    private final ReadyStatusFactory readyStatusFactory;
    private ApiService apiService;

    public DefaultHealthCheck(ApiService apiService) {
        this.apiService = apiService;
        this.readyStatusFactory = new TextReadyStatusFactory();
    }

    public boolean isInstanceTrafficAllowed() {
        boolean trafficAllowed = this.apiService.getApis().stream().noneMatch(api -> api.getImplementation().gatekeeperStatus().isBlocked());
        if (LOGGER.isDebugEnabled()) {
            this.apiService.getApis().stream().map(api -> api.getImplementation().getArtifactName()).collect(Collectors.toSet()).forEach(this::applicationTrafficAllowed);
        }
        return trafficAllowed;
    }

    protected ReadyStatus isApiTrafficAllowed(Long apiId) {
        return this.apiService.getApis().stream().filter(api -> api.getKey().id().equals(apiId)).findFirst().map(api -> this.readyStatusFactory.readyStatus(apiId, api.getImplementation().gatekeeperStatus().status())).orElseGet(() -> this.readyStatusFactory.missingApi(apiId));
    }

    protected ReadyStatus applicationTrafficAllowed(String applicationName) {
        List<ReadyStatus> statusList = this.apiService.getApis().stream().filter(api -> api.getImplementation().getArtifactName().equals(applicationName)).map(api -> this.readyStatusFactory.readyStatus(api.getKey().id(), api.getImplementation().gatekeeperStatus().status())).collect(Collectors.toList());
        ReadyStatus status = this.readyStatusFactory.readyStatus(statusList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("App {}: {}.", (Object)applicationName, (Object)(status.isReady() ? "Ready" : "Blocked"));
            status.statusDescription().ifPresent(arg_0 -> ((Logger)LOGGER).debug(arg_0));
        }
        return status;
    }

    public boolean isApplicationTrafficAllowed(String applicationName) {
        return this.applicationTrafficAllowed(applicationName).isReady();
    }

    public HealthCheckValidator getValidator(String applicationName) {
        return () -> this.applicationTrafficAllowed(applicationName);
    }

    public HealthCheckValidator getApiValidator(Long apiId) {
        return () -> this.isApiTrafficAllowed(apiId);
    }
}

