/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionBuilder;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import java.util.List;
import java.util.Map;

public class PolicyConfigurationSanitizer {
    private final boolean validate;

    public PolicyConfigurationSanitizer(boolean validate) {
        this.validate = validate;
    }

    public PolicyDefinition sanitizeAndValidate(PolicyDefinition policyDefinition, PolicyTemplate policyTemplate) {
        PolicySpecification specification = policyTemplate.getPolicySpecification();
        if (specification.isValid() && this.isIdmConfigured(policyDefinition) && !this.requiresIdm(specification)) {
            policyDefinition = this.getPolicyDefinitionWithoutIdentityManagement(policyDefinition);
        }
        if (this.validate) {
            this.validateSpecificationSchema(policyDefinition, specification);
        }
        return policyDefinition;
    }

    private void validateSpecificationSchema(PolicyDefinition policyDefinition, PolicySpecification specification) {
        if (this.requiresIdm(specification) && !this.isIdmConfigured(policyDefinition)) {
            throw new PolicyTemplateResolverException("Policy requires Identity management but was not present in the policy configuration.");
        }
        if (this.allowsMultiple(specification)) {
            List configurations = (List)policyDefinition.getConfigurationData().getConfiguration().get("configuration");
            for (Map config : configurations) {
                this.validateSingleConfiguration(specification, config);
            }
        } else {
            Map config = policyDefinition.getConfigurationData().getConfiguration();
            this.validateSingleConfiguration(specification, config);
        }
    }

    private void validateSingleConfiguration(PolicySpecification specification, Map<String, Object> config) {
        for (PolicyProperty property : specification.getConfiguration()) {
            if (property.isOptional() || config.containsKey(property.getPropertyName())) continue;
            throw new PolicyTemplateResolverException(String.format("Policy configuration required mandatory property '%s' but was absent. Configuration: %s", property.getPropertyName(), config.keySet()));
        }
    }

    private boolean requiresIdm(PolicySpecification specification) {
        return specification.getIdentityManagement().isPresent();
    }

    private boolean isIdmConfigured(PolicyDefinition definition) {
        return PolicyDefinitionBuilder.hasIdentityManagementProperties(definition);
    }

    private PolicyDefinition getPolicyDefinitionWithoutIdentityManagement(PolicyDefinition policyDefinition) {
        return new PolicyDefinitionBuilder(policyDefinition).noIdentityManagement().build();
    }

    private boolean allowsMultiple(PolicySpecification specification) {
        return specification.allowMultiple();
    }
}

