/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.KeyvalueEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.ListOfKeyvaluesEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.ListOfStringsEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.NullEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.StringEncrypter;
import java.util.ArrayList;
import java.util.List;

public class PolicyTypeEncrypters {
    private final List<PolicyTypeEncrypter> encrypters = new ArrayList<PolicyTypeEncrypter>();
    private final NullEncrypter nullEncrypter;

    public PolicyTypeEncrypters(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled, List<PolicyProperty> policyProperties) {
        this.encrypters.add(new StringEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
        this.encrypters.add(new KeyvalueEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
        this.encrypters.add(new ListOfStringsEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
        this.encrypters.add(new ListOfKeyvaluesEncrypter(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties));
        this.nullEncrypter = new NullEncrypter();
    }

    public PolicyTypeEncrypter getEncrypter(String key) {
        return this.encrypters.stream().filter(policyConfigDataEncrypter -> policyConfigDataEncrypter.supports(key)).findFirst().orElse(this.nullEncrypter);
    }
}

