/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.util.Preconditions;

public class PolicyDefinition
implements Serializable {
    private static final long serialVersionUID = -7925996663904618454L;
    private final String id;
    private final List<ApiKey> apiKeys;
    private final int order;
    private final PolicyTemplateKey templateKey;
    private final List<HttpResourcePointcut> httpResourcePointcuts;
    private final PolicyConfiguration configurationData;

    public PolicyDefinition(String id, PolicyTemplateKey templateKey, ApiKey apiKey, List<HttpResourcePointcut> httpResourcePointcuts, int order, Map<String, Object> configurationData) {
        this(id, templateKey, Collections.singletonList(apiKey), httpResourcePointcuts, order, new PolicyConfiguration(configurationData));
    }

    public PolicyDefinition(String id, PolicyTemplateKey templateKey, ApiKey apiKey, List<HttpResourcePointcut> httpResourcePointcuts, int order, PolicyConfiguration configurationData) {
        this(id, templateKey, Collections.singletonList(apiKey), httpResourcePointcuts, order, configurationData);
    }

    public PolicyDefinition(PolicyDefinition policyDefinition, PolicyConfiguration configurationData) {
        this(policyDefinition.getId(), policyDefinition.getTemplateKey(), policyDefinition.getApiKeys(), policyDefinition.getHttpResourcePointcuts(), (int)policyDefinition.getOrder(), configurationData);
    }

    public PolicyDefinition(String id, PolicyTemplateKey templateKey, List<ApiKey> apiKeys, List<HttpResourcePointcut> httpResourcePointcuts, int order, PolicyConfiguration configurationData) {
        Objects.requireNonNull(id, "Policy ID can not be null");
        Objects.requireNonNull(templateKey, "Policy Template can not be null");
        Preconditions.checkArgument((order > 0 ? 1 : 0) != 0, (String)"Policy needs to have an order");
        Preconditions.checkArgument((apiKeys != null && !apiKeys.isEmpty() ? 1 : 0) != 0, (String)"API Key of a policy can not be null");
        this.id = id;
        this.templateKey = templateKey;
        this.apiKeys = apiKeys;
        this.httpResourcePointcuts = httpResourcePointcuts != null ? httpResourcePointcuts : new ArrayList();
        this.order = order;
        this.configurationData = configurationData;
    }

    public String getName() {
        return this.templateKey.getAssetId() + "-" + this.id;
    }

    public boolean isOnline() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    public PolicyTemplateKey getTemplateKey() {
        return this.templateKey;
    }

    public List<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public Integer getOrder() {
        return this.order;
    }

    public PolicyConfiguration getConfigurationData() {
        return this.configurationData;
    }

    public List<HttpResourcePointcut> getHttpResourcePointcuts() {
        return this.httpResourcePointcuts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyDefinition that = (PolicyDefinition)o;
        if (this.order != that.order) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.apiKeys, that.apiKeys)) {
            return false;
        }
        if (!Objects.equals(this.templateKey, that.templateKey)) {
            return false;
        }
        if (!Objects.equals(this.httpResourcePointcuts, that.httpResourcePointcuts)) {
            return false;
        }
        return this.configurationData.getConfigurationVersion().equals(that.configurationData.getConfigurationVersion());
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.apiKeys != null ? this.apiKeys.hashCode() : 0);
        result = 31 * result + this.order;
        result = 31 * result + (this.templateKey != null ? this.templateKey.hashCode() : 0);
        result = 31 * result + (this.httpResourcePointcuts != null ? this.httpResourcePointcuts.hashCode() : 0);
        result = 31 * result + (this.configurationData != null ? Integer.parseInt(this.configurationData.getConfigurationVersion()) : 0);
        return result;
    }

    public String toString() {
        return "PolicyDefinition{id='" + this.id + '\'' + ", apiKeys=" + this.apiKeys + ", order=" + this.order + ", templateKey=" + this.templateKey + ", httpResourcePointcuts=" + this.httpResourcePointcuts + ", configurationData=" + this.configurationData + '}';
    }
}

