/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.contract.tier;

import com.google.common.collect.Lists;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeTier
implements Tier,
Serializable {
    private static final long serialVersionUID = -7517192138560153981L;
    private final List<Tier> tiers;

    public CompositeTier(Tier ... tiers) {
        this.tiers = Lists.newArrayList((Object[])tiers);
    }

    public CompositeTier(List<Tier> tiers) {
        this.tiers = Lists.newArrayList(tiers);
    }

    @Override
    public List<SingleTier> flattened() {
        return this.tiers.stream().map(tier -> tier.flattened()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean tiersIn(List<Tier> anotherTiers) {
        return this.tiers.stream().allMatch(tier -> anotherTiers.contains(tier));
    }

    public int hashCode() {
        return this.tiers != null ? this.tiers.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeTier)) {
            return false;
        }
        CompositeTier otherSLA = (CompositeTier)o;
        return this.tiersIn(otherSLA.tiers) && otherSLA.tiersIn(this.tiers);
    }

    public String toString() {
        return "CompositeTier{tiers=" + this.tiers.stream().map(tier -> tier.toString()).reduce("", (appendedTiers, lastTier) -> lastTier + ", " + appendedTiers) + "}";
    }
}

