/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.httpobjects;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HttpServletObjectsHolder {
    private static final HttpServletRequest currentHttpServletRequest = new CurrentHttpServletRequest();
    private static final HttpServletResponse currentHttpServletResponse = new CurrentHttpServletResponse();
    private static final ThreadLocal<HttpServletRequest> requestHolder = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> responseHolder = new ThreadLocal();

    public static HttpServletRequest getRequest() {
        return requestHolder.get();
    }

    public static HttpServletRequest getRequestFacade() {
        return currentHttpServletRequest;
    }

    public static HttpServletResponse getResponse() {
        return responseHolder.get();
    }

    public static HttpServletResponse getResponseFacade() {
        return currentHttpServletResponse;
    }

    public static void setRequest(HttpServletRequest request) {
        requestHolder.set(request);
    }

    public static void setResponse(HttpServletResponse response) {
        responseHolder.set(response);
    }

    private static class CurrentHttpServletResponse
    implements HttpServletResponse {
        private CurrentHttpServletResponse() {
        }

        public void addCookie(Cookie cookie) {
            HttpServletObjectsHolder.getResponse().addCookie(cookie);
        }

        public void addDateHeader(String name, long date) {
            HttpServletObjectsHolder.getResponse().addDateHeader(name, date);
        }

        public void addHeader(String name, String value) {
            HttpServletObjectsHolder.getResponse().addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            HttpServletObjectsHolder.getResponse().addIntHeader(name, value);
        }

        public boolean containsHeader(String name) {
            return HttpServletObjectsHolder.getResponse().containsHeader(name);
        }

        public String encodeRedirectUrl(String url) {
            return HttpServletObjectsHolder.getResponse().encodeRedirectUrl(url);
        }

        public String encodeRedirectURL(String url) {
            return HttpServletObjectsHolder.getResponse().encodeRedirectURL(url);
        }

        public String encodeUrl(String url) {
            return HttpServletObjectsHolder.getResponse().encodeUrl(url);
        }

        public String encodeURL(String url) {
            return HttpServletObjectsHolder.getResponse().encodeURL(url);
        }

        public void flushBuffer() throws IOException {
            HttpServletObjectsHolder.getResponse().flushBuffer();
        }

        public int getBufferSize() {
            return HttpServletObjectsHolder.getResponse().getBufferSize();
        }

        public String getCharacterEncoding() {
            return HttpServletObjectsHolder.getResponse().getCharacterEncoding();
        }

        public String getContentType() {
            return HttpServletObjectsHolder.getResponse().getContentType();
        }

        public Locale getLocale() {
            return HttpServletObjectsHolder.getResponse().getLocale();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return HttpServletObjectsHolder.getResponse().getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            return HttpServletObjectsHolder.getResponse().getWriter();
        }

        public boolean isCommitted() {
            return HttpServletObjectsHolder.getResponse().isCommitted();
        }

        public void reset() {
            HttpServletObjectsHolder.getResponse().reset();
        }

        public void resetBuffer() {
            HttpServletObjectsHolder.getResponse().resetBuffer();
        }

        public void sendError(int sc) throws IOException {
            HttpServletObjectsHolder.getResponse().sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            HttpServletObjectsHolder.getResponse().sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            HttpServletObjectsHolder.getResponse().sendRedirect(location);
        }

        public void setBufferSize(int size) {
            HttpServletObjectsHolder.getResponse().setBufferSize(size);
        }

        public void setCharacterEncoding(String charset) {
            HttpServletObjectsHolder.getResponse().setCharacterEncoding(charset);
        }

        public void setContentLength(int len) {
            HttpServletObjectsHolder.getResponse().setContentLength(len);
        }

        public void setContentType(String type) {
            HttpServletObjectsHolder.getResponse().setContentType(type);
        }

        public void setDateHeader(String name, long date) {
            HttpServletObjectsHolder.getResponse().setDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            HttpServletObjectsHolder.getResponse().setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            HttpServletObjectsHolder.getResponse().setIntHeader(name, value);
        }

        public void setLocale(Locale loc) {
            HttpServletObjectsHolder.getResponse().setLocale(loc);
        }

        public void setStatus(int sc) {
            HttpServletObjectsHolder.getResponse().setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            HttpServletObjectsHolder.getResponse().setStatus(sc, sm);
        }
    }

    private static class CurrentHttpServletRequest
    implements HttpServletRequest {
        private CurrentHttpServletRequest() {
        }

        public Object getAttribute(String name) {
            return HttpServletObjectsHolder.getRequest().getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return HttpServletObjectsHolder.getRequest().getAttributeNames();
        }

        public String getAuthType() {
            return HttpServletObjectsHolder.getRequest().getAuthType();
        }

        public String getCharacterEncoding() {
            return HttpServletObjectsHolder.getRequest().getCharacterEncoding();
        }

        public int getContentLength() {
            return HttpServletObjectsHolder.getRequest().getContentLength();
        }

        public String getContentType() {
            return HttpServletObjectsHolder.getRequest().getContentType();
        }

        public String getContextPath() {
            return HttpServletObjectsHolder.getRequest().getContextPath();
        }

        public Cookie[] getCookies() {
            return HttpServletObjectsHolder.getRequest().getCookies();
        }

        public long getDateHeader(String name) {
            return HttpServletObjectsHolder.getRequest().getDateHeader(name);
        }

        public String getHeader(String name) {
            return HttpServletObjectsHolder.getRequest().getHeader(name);
        }

        public Enumeration getHeaderNames() {
            return HttpServletObjectsHolder.getRequest().getHeaderNames();
        }

        public Enumeration getHeaders(String name) {
            return HttpServletObjectsHolder.getRequest().getHeaders(name);
        }

        public ServletInputStream getInputStream() throws IOException {
            return HttpServletObjectsHolder.getRequest().getInputStream();
        }

        public int getIntHeader(String name) {
            return HttpServletObjectsHolder.getRequest().getIntHeader(name);
        }

        public String getLocalAddr() {
            return HttpServletObjectsHolder.getRequest().getLocalAddr();
        }

        public Locale getLocale() {
            return HttpServletObjectsHolder.getRequest().getLocale();
        }

        public Enumeration getLocales() {
            return HttpServletObjectsHolder.getRequest().getLocales();
        }

        public String getLocalName() {
            return HttpServletObjectsHolder.getRequest().getLocalName();
        }

        public int getLocalPort() {
            return HttpServletObjectsHolder.getRequest().getLocalPort();
        }

        public String getMethod() {
            return HttpServletObjectsHolder.getRequest().getMethod();
        }

        public String getParameter(String name) {
            return HttpServletObjectsHolder.getRequest().getParameter(name);
        }

        public Map getParameterMap() {
            return HttpServletObjectsHolder.getRequest().getParameterMap();
        }

        public Enumeration getParameterNames() {
            return HttpServletObjectsHolder.getRequest().getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return HttpServletObjectsHolder.getRequest().getParameterValues(name);
        }

        public String getPathInfo() {
            return HttpServletObjectsHolder.getRequest().getPathInfo();
        }

        public String getPathTranslated() {
            return HttpServletObjectsHolder.getRequest().getPathTranslated();
        }

        public String getProtocol() {
            return HttpServletObjectsHolder.getRequest().getProtocol();
        }

        public String getQueryString() {
            return HttpServletObjectsHolder.getRequest().getQueryString();
        }

        public BufferedReader getReader() throws IOException {
            return HttpServletObjectsHolder.getRequest().getReader();
        }

        public String getRealPath(String path) {
            return HttpServletObjectsHolder.getRequest().getRealPath(path);
        }

        public String getRemoteAddr() {
            return HttpServletObjectsHolder.getRequest().getRemoteAddr();
        }

        public String getRemoteHost() {
            return HttpServletObjectsHolder.getRequest().getRemoteHost();
        }

        public int getRemotePort() {
            return HttpServletObjectsHolder.getRequest().getRemotePort();
        }

        public String getRemoteUser() {
            return HttpServletObjectsHolder.getRequest().getRemoteUser();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return HttpServletObjectsHolder.getRequest().getRequestDispatcher(path);
        }

        public String getRequestedSessionId() {
            return HttpServletObjectsHolder.getRequest().getRequestedSessionId();
        }

        public String getRequestURI() {
            return HttpServletObjectsHolder.getRequest().getRequestURI();
        }

        public StringBuffer getRequestURL() {
            return HttpServletObjectsHolder.getRequest().getRequestURL();
        }

        public String getScheme() {
            return HttpServletObjectsHolder.getRequest().getScheme();
        }

        public String getServerName() {
            return HttpServletObjectsHolder.getRequest().getServerName();
        }

        public int getServerPort() {
            return HttpServletObjectsHolder.getRequest().getServerPort();
        }

        public String getServletPath() {
            return HttpServletObjectsHolder.getRequest().getServletPath();
        }

        public HttpSession getSession() {
            return HttpServletObjectsHolder.getRequest().getSession();
        }

        public HttpSession getSession(boolean create) {
            return HttpServletObjectsHolder.getRequest().getSession(create);
        }

        public Principal getUserPrincipal() {
            return HttpServletObjectsHolder.getRequest().getUserPrincipal();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return HttpServletObjectsHolder.getRequest().isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return HttpServletObjectsHolder.getRequest().isRequestedSessionIdFromUrl();
        }

        public boolean isRequestedSessionIdFromURL() {
            return HttpServletObjectsHolder.getRequest().isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdValid() {
            return HttpServletObjectsHolder.getRequest().isRequestedSessionIdValid();
        }

        public boolean isSecure() {
            return HttpServletObjectsHolder.getRequest().isSecure();
        }

        public boolean isUserInRole(String role) {
            return HttpServletObjectsHolder.getRequest().isUserInRole(role);
        }

        public void removeAttribute(String name) {
            HttpServletObjectsHolder.getRequest().removeAttribute(name);
        }

        public void setAttribute(String name, Object o) {
            HttpServletObjectsHolder.getRequest().setAttribute(name, o);
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            HttpServletObjectsHolder.getRequest().setCharacterEncoding(env);
        }
    }
}

