/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ByteArraySet
extends AbstractCollection<byte[]>
implements Set<byte[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Set<ByteArrayMap.Element> set;

    public ByteArraySet(Set<? extends byte[]> m) {
        this(true, m);
    }

    public ByteArraySet(boolean ordered, Set<? extends byte[]> m) {
        this(ordered, m == null ? 0 : m.size(), 0.75f);
        this.addAll(m);
    }

    public ByteArraySet() {
        this(true);
    }

    public ByteArraySet(boolean ordered) {
        this(ordered, 16);
    }

    public ByteArraySet(boolean ordered, int initialCapacity) {
        this(ordered, initialCapacity, 0.75f);
    }

    public ByteArraySet(boolean ordered, int initialCapacity, float loadFactor) {
        this.set = ordered ? new LinkedHashSet<ByteArrayMap.Element>(initialCapacity, loadFactor) : new HashSet<ByteArrayMap.Element>(initialCapacity, loadFactor);
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iter();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(new ByteArrayMap.Element((byte[])o));
    }

    @Override
    public boolean add(byte[] e) {
        return this.set.add(new ByteArrayMap.Element(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(new ByteArrayMap.Element((byte[])o));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private final class Iter
    implements Iterator<byte[]> {
        private Iterator<ByteArrayMap.Element> it;

        private Iter() {
            this.it = ByteArraySet.this.set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public byte[] next() {
            return this.it.next().bytes;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

