/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import com.moilioncircle.redis.replicator.util.ByteBuilder;
import com.moilioncircle.redis.replicator.util.CRC64;
import java.io.IOException;
import java.util.NoSuchElementException;

public class DumpRdbValueVisitor
extends DefaultRdbValueVisitor {
    private final int size;
    private final int version;

    public DumpRdbValueVisitor(Replicator replicator) {
        this(replicator, -1);
    }

    public DumpRdbValueVisitor(Replicator replicator, int version) {
        this(replicator, version, 8192);
    }

    public DumpRdbValueVisitor(Replicator replicator, int version, int size) {
        super(replicator);
        this.version = version;
        this.size = size;
    }

    @Override
    public <T> T applyString(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(0, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadEncodedStringObject();
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(1, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applySet(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(2, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyZSet(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(3, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadDoubleValue();
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyZSet2(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(5, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadBinaryDoubleValue();
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyHash(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(4, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyHashZipMap(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(9, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyListZipList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(10, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applySetIntSet(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(11, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyZSetZipList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(12, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyHashZipList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(13, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyListQuickList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(14, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long len = skipParser.rdbLoadLen().len;
        for (long i = 0L; i < len; ++i) {
            skipParser.rdbGenericLoadStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyModule(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(6, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skipParser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
        }
        moduleParser.parse(in, 1);
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyModule2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DefaultRawByteListener listener = new DefaultRawByteListener(7, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skipParser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            SkipRdbParser skipRdbParser = new SkipRdbParser(in);
            skipRdbParser.rdbLoadCheckModuleValue();
        } else {
            moduleParser.parse(in, 2);
            long eof = parser.rdbLoadLen().len;
            if (eof != 0L) {
                throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
            }
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    @Override
    public <T> T applyStreamListPacks(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(15, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long listPacks = skipParser.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            skipParser.rdbLoadPlainStringObject();
            skipParser.rdbLoadPlainStringObject();
        }
        skipParser.rdbLoadLen();
        skipParser.rdbLoadLen();
        skipParser.rdbLoadLen();
        long groupCount = skipParser.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            skipParser.rdbLoadPlainStringObject();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            long groupPel = skipParser.rdbLoadLen().len;
            while (groupPel-- > 0L) {
                in.skip(16L);
                skipParser.rdbLoadMillisecondTime();
                skipParser.rdbLoadLen();
            }
            long consumerCount = skipParser.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                skipParser.rdbLoadPlainStringObject();
                skipParser.rdbLoadMillisecondTime();
                long consumerPel = skipParser.rdbLoadLen().len;
                while (consumerPel-- > 0L) {
                    in.skip(16L);
                }
            }
        }
        this.replicator.removeRawByteListener(listener);
        return (T)listener.getBytes();
    }

    private class DefaultRawByteListener
    implements RawByteListener {
        private final int version;
        private final ByteBuilder builder;

        private DefaultRawByteListener(byte type, int version) {
            this.builder = ByteBuilder.allocate(DumpRdbValueVisitor.this.size);
            this.builder.put(type);
            int ver = DumpRdbValueVisitor.this.version;
            this.version = ver == -1 ? version : ver;
        }

        @Override
        public void handle(byte ... rawBytes) {
            for (byte b : rawBytes) {
                this.builder.put(b);
            }
        }

        public byte[] getBytes() {
            byte[] crc;
            this.builder.put((byte)this.version);
            this.builder.put((byte)0);
            byte[] bytes = this.builder.array();
            for (byte b : crc = CRC64.longToByteArray(CRC64.crc64(bytes))) {
                this.builder.put(b);
            }
            return this.builder.array();
        }
    }
}

