/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.ExistType;
import com.moilioncircle.redis.replicator.cmd.impl.ZAddCommand;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;

public class ZAddParser
implements CommandParser<ZAddCommand> {
    @Override
    public ZAddCommand parse(Object[] command) {
        int idx = 1;
        boolean isCh = false;
        boolean isIncr = false;
        ExistType existType = ExistType.NONE;
        ArrayList<ZSetEntry> list = new ArrayList<ZSetEntry>();
        byte[] key = CommandParsers.toBytes(command[idx]);
        ++idx;
        boolean et = false;
        while (idx < command.length) {
            String param = CommandParsers.toRune(command[idx]);
            if (!et && Strings.isEquals(param, "NX")) {
                existType = ExistType.NX;
                et = true;
                ++idx;
                continue;
            }
            if (!et && Strings.isEquals(param, "XX")) {
                existType = ExistType.XX;
                et = true;
                ++idx;
                continue;
            }
            if (!isCh && Strings.isEquals(param, "CH")) {
                isCh = true;
            } else if (!isIncr && Strings.isEquals(param, "INCR")) {
                isIncr = true;
            } else {
                double score = Double.parseDouble(param);
                byte[] member = CommandParsers.toBytes(command[++idx]);
                list.add(new ZSetEntry(member, score));
            }
            ++idx;
        }
        ZSetEntry[] zSetEntries = new ZSetEntry[list.size()];
        list.toArray(zSetEntries);
        return new ZAddCommand(key, existType, isCh, isIncr, zSetEntries);
    }
}

